//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.util.console;

import org.junit.*;

import de.ugoe.cs.util.console.mock.MockOutputListener;
import static org.junit.Assert.*;

/**
 * The class <code>CommandExecuterTest</code> contains tests for the class
 * <code>{@link CommandExecuter}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CommandExecuterTest {

	@Test(expected=java.lang.IllegalArgumentException.class)
	public void testAddCommandPackage_1()
		throws Exception {
		CommandExecuter fixture = CommandExecuter.getInstance();

		fixture.addCommandPackage("");
	}

	@Test(expected=java.lang.IllegalArgumentException.class)
	public void testAddCommandPackage_2()
		throws Exception {
		CommandExecuter fixture = CommandExecuter.getInstance();
		
		fixture.addCommandPackage(null);
	}

	@Test
	public void testExec_1()
		throws Exception {
		CommandExecuter fixture = CommandExecuter.getInstance();
		MockOutputListener mockListener = new MockOutputListener();
		Console.getInstance().registerOutputListener(mockListener);
		fixture.addCommandPackage("de.ugoe.cs.util.console.mock.commands");
		String command = "mockCommand";
		String expected = "mock command: run" + System.getProperty("line.separator");

		fixture.exec(command);

		assertEquals(expected, mockListener.getLastOutput());
	}
	
	@Test
	public void testExec_2()
		throws Exception {
		CommandExecuter fixture = CommandExecuter.getInstance();
		MockOutputListener mockListener = new MockOutputListener();
		Console.getInstance().registerOutputListener(mockListener);
		fixture.addCommandPackage("de.ugoe.cs.util.console.mock.commands");
		String command = "mockCommand param1";
		String expected = "Usage: mock command: help" + System.getProperty("line.separator");

		fixture.exec(command);

		assertEquals(expected, mockListener.getLastOutput());
	}
	
	@Test
	public void testExec_3()
		throws Exception {
		CommandExecuter fixture = CommandExecuter.getInstance();
		MockOutputListener mockListener = new MockOutputListener();
		Console.getInstance().registerOutputListener(mockListener);
		fixture.addCommandPackage("de.ugoe.cs.util.console.mock.commands");
		String command = "mockCommand param1 param2";

		fixture.exec(command);
	}
	
	@Test
	public void testExec_4()
		throws Exception {
		CommandExecuter fixture = CommandExecuter.getInstance();
		MockOutputListener mockListener = new MockOutputListener();
		Console.getInstance().registerOutputListener(mockListener);
		fixture.addCommandPackage("de.ugoe.cs.util.console.mock.commands");
		String command = "mockCommandddd";
		String expected = "Unknown command" + System.getProperty("line.separator");
		
		fixture.exec(command);
		
		assertEquals(expected, mockListener.getLastOutput());
	}

	@Test
	public void testGetInstance_1()
		throws Exception {
		CommandExecuter result = CommandExecuter.getInstance();

		assertNotNull(result);
	}
	
	@BeforeClass
	public static void setupBeforeClass() {
		Console.reset();
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(CommandExecuterTest.class);
	}
}