/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.httpmonitor.proxy;

import de.ugoe.cs.autoquest.httpmonitor.exchange.Status;
import de.ugoe.cs.autoquest.httpmonitor.proxy.ExchangeListenerManager;
import de.ugoe.cs.util.console.Console;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.jetty.util.Fields;

class HttpMonitoringProxyServlet
extends ProxyServlet {
    private static final long serialVersionUID = 1L;
    private String proxiedServer;
    private int proxiedPort;
    private transient ExchangeListenerManager exchangeListenerManager;

    HttpMonitoringProxyServlet(String proxiedServer, int proxiedPort, ExchangeListenerManager exchangeListenerManager) {
        this.proxiedServer = proxiedServer;
        this.proxiedPort = proxiedPort;
        this.exchangeListenerManager = exchangeListenerManager;
    }

    protected URI rewriteURI(HttpServletRequest request) {
        try {
            return new URI(request.getScheme(), null, this.proxiedServer, this.proxiedPort, request.getPathInfo(), request.getQueryString(), null);
        }
        catch (URISyntaxException e) {
            Console.printerrln((String)("could not rewrite URI: " + e));
            Console.logException((Exception)e);
            return null;
        }
    }

    protected HttpClient newHttpClient() {
        return new BugfixedHttpClient();
    }

    protected void customizeProxyRequest(Request proxyRequest, HttpServletRequest request) {
        super.customizeProxyRequest(proxyRequest, request);
        this.exchangeListenerManager.onRequest(request);
        proxyRequest.content((ContentProvider)new DubbingContentProvider(request, proxyRequest.getContent()));
    }

    protected void onResponseContent(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, byte[] buffer, int offset, int length) throws IOException {
        super.onResponseContent(request, response, proxyResponse, buffer, offset, length);
        this.exchangeListenerManager.onResponseContent(request, ByteBuffer.wrap(buffer, offset, length));
    }

    protected void onResponseSuccess(HttpServletRequest request, HttpServletResponse response, Response proxyResponse) {
        this.exchangeListenerManager.onResponse(request, response);
        this.exchangeListenerManager.onFinish(request, Status.SUCCESS);
        super.onResponseSuccess(request, response, proxyResponse);
    }

    protected void onResponseFailure(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, Throwable failure) {
        this.exchangeListenerManager.onResponse(request, response);
        this.exchangeListenerManager.onFinish(request, Status.FAILURE);
        super.onResponseFailure(request, response, proxyResponse, failure);
    }

    private static class BugfixedHttpClient
    extends HttpClient {
        private BugfixedHttpClient() {
        }

        public Request newRequest(URI uri) {
            return new BugfixedHttpRequest(this, uri);
        }
    }

    private static class BugfixedHttpRequest
    extends HttpRequest {
        BugfixedHttpRequest(HttpClient client, URI uri) {
            super(client, uri);
        }

        public String getQuery() {
            return this.buildQuery();
        }

        private String buildQuery() {
            StringBuilder result = new StringBuilder();
            Iterator iterator = super.getParams().iterator();
            while (iterator.hasNext()) {
                Fields.Field field = (Fields.Field)iterator.next();
                String[] values = field.values();
                int i = 0;
                while (i < values.length) {
                    if (i > 0) {
                        result.append("&");
                    }
                    result.append(field.name());
                    if (values[i] != null && !"".equals(values[i].trim())) {
                        result.append("=");
                        result.append(this.urlEncode(values[i]));
                    }
                    ++i;
                }
                if (!iterator.hasNext()) continue;
                result.append("&");
            }
            return result.toString();
        }

        private String urlEncode(String value) {
            String encoding = "UTF-8";
            try {
                return URLEncoder.encode(value, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedCharsetException(encoding);
            }
        }
    }

    public class DubbingByteBufferIterator
    implements Iterator<ByteBuffer> {
        private HttpServletRequest request;
        private Iterator<ByteBuffer> delegate;

        public DubbingByteBufferIterator(HttpServletRequest request, Iterator<ByteBuffer> delegate) {
            this.request = request;
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public ByteBuffer next() {
            LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
            int size = 0;
            while (this.delegate.hasNext()) {
                ByteBuffer next = this.delegate.next();
                HttpMonitoringProxyServlet.this.exchangeListenerManager.onRequestContent(this.request, next.duplicate());
                ByteBuffer copy = ByteBuffer.allocate(next.limit());
                copy.put(next);
                copy.position(0);
                buffers.add(copy);
                size += next.limit();
            }
            ByteBuffer buffer = ByteBuffer.allocate(size);
            for (ByteBuffer orig : buffers) {
                buffer.put(orig);
            }
            buffer.position(0);
            return buffer;
        }

        @Override
        public void remove() {
            while (this.delegate.hasNext()) {
                this.delegate.remove();
            }
        }
    }

    private class DubbingContentProvider
    implements ContentProvider {
        private HttpServletRequest request;
        private ContentProvider delegate;

        public DubbingContentProvider(HttpServletRequest request, ContentProvider delegate) {
            this.request = request;
            this.delegate = delegate;
        }

        public Iterator<ByteBuffer> iterator() {
            return new DubbingByteBufferIterator(this.request, this.delegate.iterator());
        }

        public long getLength() {
            return this.delegate.getLength();
        }
    }
}

