/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.plugin.http.eventcore;

import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.httpmonitor.exchange.HttpExchange;
import de.ugoe.cs.autoquest.httpmonitor.exchange.HttpRequest;
import de.ugoe.cs.autoquest.plugin.http.HTTPUtils;

public class HTTPEventType
implements IEventType {
    private static final long serialVersionUID = 1L;
    private HttpExchange exchange;
    private String name;

    public HTTPEventType(HttpExchange exchange) {
        if (exchange == null) {
            throw new IllegalArgumentException("exchange must not be null");
        }
        this.exchange = exchange;
        StringBuffer nameBuffer = new StringBuffer("HTTPEvent");
        boolean somethingAdded = false;
        if (this.exchange.getRequest() != null && this.exchange.getRequest().getMethod() != null) {
            nameBuffer.append("(");
            nameBuffer.append((Object)this.exchange.getRequest().getMethod());
            somethingAdded = true;
        }
        String senderStr = HTTPUtils.toString(this.exchange.getSender());
        String receiverStr = HTTPUtils.toString(this.exchange.getReceiver());
        if (senderStr != null && receiverStr != null) {
            nameBuffer.append(somethingAdded ? ", " : "(");
            nameBuffer.append(senderStr);
            nameBuffer.append(" --> ");
            nameBuffer.append(receiverStr);
            somethingAdded = true;
        } else if (senderStr != null) {
            nameBuffer.append(somethingAdded ? ", " : "(");
            nameBuffer.append(senderStr);
            somethingAdded = true;
        } else if (receiverStr != null) {
            nameBuffer.append(somethingAdded ? ", " : "(");
            nameBuffer.append(receiverStr);
            somethingAdded = true;
        }
        if (somethingAdded) {
            nameBuffer.append(")");
        }
        this.name = nameBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public HttpExchange getExchange() {
        return this.exchange;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HTTPEventType) {
            HTTPEventType other = (HTTPEventType)obj;
            HttpRequest request1 = this.exchange.getRequest();
            HttpRequest request2 = other.exchange.getRequest();
            return HTTPUtils.equals(this.exchange.getSender(), other.exchange.getSender()) && HTTPUtils.equals(this.exchange.getReceiver(), other.exchange.getReceiver()) && HTTPUtils.equals(request1.getMethod(), request2.getMethod()) && HTTPUtils.equals(request1.getProtocol(), request2.getProtocol()) && HTTPUtils.equals(request1.getUrl(), request2.getUrl());
        }
        return false;
    }

    public int hashCode() {
        return this.exchange.getRequest().getMethod().hashCode() + this.exchange.getRequest().getProtocol().hashCode() + this.exchange.getRequest().getUrl().hashCode();
    }
}

