/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.eventcore.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModelConfigurationException;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementFactory;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;
import de.ugoe.cs.util.console.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.logging.Level;

public class GUIElementFactory
implements IGUIElementFactory {
    private static GUIElementFactory instance = new GUIElementFactory();
    private Properties mappingsFromConfiguration;

    private GUIElementFactory() {
    }

    public static synchronized GUIElementFactory getInstance() {
        return instance;
    }

    @Override
    public IGUIElement instantiateGUIElement(IGUIElementSpec specification, IGUIElement parent) throws GUIModelConfigurationException {
        IGUIElement guiElement;
        block20: {
            Properties mappings = this.getMappingsFromConfiguration();
            guiElement = null;
            String[] typeHierarchy = specification.getTypeHierarchy();
            int i = 0;
            String className = null;
            while (className == null && i < typeHierarchy.length) {
                className = mappings.getProperty(typeHierarchy[i]);
                ++i;
            }
            if (className != null) {
                Class<?> clazz;
                block19: {
                    clazz = this.getClass().getClassLoader().loadClass(className);
                    if (IGUIElement.class.isAssignableFrom(clazz)) break block19;
                    Console.traceln((Level)Level.WARNING, (String)("configured GUI element representing class " + className + " is no valid GUIElement derivate."));
                    return null;
                }
                try {
                    Constructor<?> candidate;
                    Constructor<?> constructor = null;
                    Class<?> parentClass = parent == null ? null : parent.getClass();
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    int n = constructorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        candidate = constructorArray[n2];
                        if (parentClass != null && candidate.getParameterTypes().length == 2 && candidate.getParameterTypes()[0].equals(specification.getClass()) && candidate.getParameterTypes()[1].equals(parentClass)) {
                            constructor = candidate;
                            break;
                        }
                        if (parentClass == null && candidate.getParameterTypes().length >= 1 && candidate.getParameterTypes()[0].equals(specification.getClass())) {
                            constructor = candidate;
                            break;
                        }
                        ++n2;
                    }
                    if (constructor == null) {
                        constructorArray = clazz.getConstructors();
                        n = constructorArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            candidate = constructorArray[n2];
                            if (candidate.getParameterTypes().length == 2 && candidate.getParameterTypes()[0].isInstance(specification) && candidate.getParameterTypes()[1].isInstance(parent)) {
                                constructor = candidate;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (constructor != null) {
                        guiElement = (IGUIElement)constructor.newInstance(specification, parent);
                        break block20;
                    }
                    throw new NoSuchMethodException("no constructor with two parameters and assignable parameter types for " + specification.getClass() + " and " + (parent != null ? parent.getClass() : "null") + " found in class " + clazz);
                }
                catch (ClassNotFoundException e) {
                    Console.traceln((Level)Level.WARNING, (String)("configured GUI element representing class " + className + " can not be loaded."));
                    throw new GUIModelConfigurationException("configured GUI element representing class " + className + " can not be loaded.", e);
                }
                catch (SecurityException e) {
                    Console.traceln((Level)Level.WARNING, (String)("configured GUI element representing class " + className + " can not be instantiated due to security reasons."));
                    throw new GUIModelConfigurationException("configured GUI element representing class " + className + " can not be instantiated due to security reasons.", e);
                }
                catch (NoSuchMethodException e) {
                    Console.traceln((Level)Level.WARNING, (String)("configured GUI element representing class " + className + " does not provide an appropriate constructor."));
                    throw new GUIModelConfigurationException("configured GUI element representing class " + className + " does not provide an appropriate constructor.", e);
                }
                catch (IllegalArgumentException e) {
                    Console.traceln((Level)Level.WARNING, (String)("configured GUI element representing class " + className + " does not provide an appropriate constructor " + "accepting the provided parameters."));
                    throw new GUIModelConfigurationException("configured GUI element representing class " + className + " does not " + "provide an appropriate constructor accepting the provided parameters.", e);
                }
                catch (InstantiationException e) {
                    Console.traceln((Level)Level.WARNING, (String)("configured GUI element representing class " + className + " can not be instantiated."));
                    throw new GUIModelConfigurationException("configured GUI element representing class " + className + " can not be instantiated.", e);
                }
                catch (IllegalAccessException e) {
                    Console.traceln((Level)Level.WARNING, (String)("configured GUI element representing class " + className + " can not be instantiated."));
                    throw new GUIModelConfigurationException("configured GUI element representing class " + className + " can not be instantiated.", e);
                }
                catch (InvocationTargetException e) {
                    Console.traceln((Level)Level.WARNING, (String)("configured GUI element representing class " + className + " can not be instantiated."));
                    throw new GUIModelConfigurationException("configured GUI element representing class " + className + " can not be instantiated.", e);
                }
            }
        }
        if (guiElement == null) {
            Console.traceln((Level)Level.WARNING, (String)("no class representing GUI elements of type " + specification.getType() + " found. Please extend GUI element " + "mapping files."));
            throw new GUIModelConfigurationException("no class representing GUI elements of type " + specification.getType() + " found. Please extend GUI element mapping files");
        }
        return guiElement;
    }

    private synchronized Properties getMappingsFromConfiguration() throws GUIModelConfigurationException {
        if (this.mappingsFromConfiguration != null) {
            return this.mappingsFromConfiguration;
        }
        this.mappingsFromConfiguration = new Properties();
        File mappingsFolder = new File("data/guimappings");
        File[] children = mappingsFolder.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File mappingsFile = fileArray[n2];
                if (!mappingsFile.isDirectory() && mappingsFile.getName().startsWith("guimapping") && mappingsFile.getName().endsWith(".txt")) {
                    FileInputStream inStream = null;
                    try {
                        try {
                            inStream = new FileInputStream(mappingsFile);
                            this.mappingsFromConfiguration.load(inStream);
                        }
                        catch (FileNotFoundException e) {
                            throw new GUIModelConfigurationException("could not read mapping configuration file " + mappingsFile, e);
                        }
                        catch (IOException e) {
                            throw new GUIModelConfigurationException("could not read mapping configuration file " + mappingsFile, e);
                        }
                    }
                    finally {
                        if (inStream != null) {
                            try {
                                ((InputStream)inStream).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                ++n2;
            }
        } else {
            throw new GUIModelConfigurationException("no GUI mappings file provided in folder " + mappingsFolder);
        }
        return this.mappingsFromConfiguration;
    }
}

