/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.httpmonitor;

import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorComponent;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorException;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorExchangeHandler;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorOutputWriter;
import de.ugoe.cs.autoquest.httpmonitor.exchange.HttpExchange;
import de.ugoe.cs.util.console.Console;
import java.util.Timer;
import java.util.TimerTask;

public class HttpMonitorLogManager
implements HttpMonitorComponent,
HttpMonitorExchangeHandler {
    private static final int SESSION_TIMEOUT = 600000;
    private String logFileBaseDir;
    private HttpMonitorOutputWriter writer;
    private Timer logFileMonitorTimer;

    public HttpMonitorLogManager(String logFileBaseDir) {
        this.logFileBaseDir = logFileBaseDir;
    }

    @Override
    public synchronized void init() throws IllegalStateException, HttpMonitorException {
        if (this.logFileMonitorTimer != null) {
            throw new IllegalStateException("already initialized");
        }
        this.logFileMonitorTimer = new Timer();
    }

    @Override
    public synchronized void start() throws IllegalStateException, HttpMonitorException {
        if (this.logFileMonitorTimer == null) {
            throw new IllegalStateException("not initialized");
        }
        this.logFileMonitorTimer.schedule((TimerTask)new LogFileMonitorTimerTask(), 300000L, 300000L);
    }

    @Override
    public synchronized void stop() {
        if (this.logFileMonitorTimer != null) {
            this.logFileMonitorTimer.cancel();
        }
        if (this.writer != null) {
            this.writer.stop();
        }
        this.writer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleHttpExchange(HttpExchange httpExchange) {
        block8: {
            try {
                if (this.writer == null) {
                    this.writer = new HttpMonitorOutputWriter(this.logFileBaseDir);
                    this.writer.init();
                }
                this.writer.handleHttpExchange(httpExchange);
            }
            catch (Exception e) {
                Console.printerrln("could not handle message: " + e);
                Console.logException(e);
                if (this.writer == null) break block8;
                try {
                    this.writer.handleHttpExchange(httpExchange);
                }
                catch (Exception e1) {
                    HttpMonitorLogManager httpMonitorLogManager = this;
                    synchronized (httpMonitorLogManager) {
                        this.writer.stop();
                        this.writer = null;
                    }
                }
            }
        }
    }

    public class LogFileMonitorTimerTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpMonitorLogManager httpMonitorLogManager = HttpMonitorLogManager.this;
            synchronized (httpMonitorLogManager) {
                if (HttpMonitorLogManager.this.writer != null && System.currentTimeMillis() - HttpMonitorLogManager.this.writer.getLastUpdate() > 600000L) {
                    HttpMonitorLogManager.this.writer.stop();
                    HttpMonitorLogManager.this.writer = null;
                }
            }
        }
    }
}

