/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.httpmonitor.proxy;

import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorExchangeHandler;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Address;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Content;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Cookie;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Cookies;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Header;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Headers;
import de.ugoe.cs.autoquest.httpmonitor.exchange.HttpExchange;
import de.ugoe.cs.autoquest.httpmonitor.exchange.HttpRequest;
import de.ugoe.cs.autoquest.httpmonitor.exchange.HttpResponse;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Method;
import de.ugoe.cs.autoquest.httpmonitor.exchange.ObjectFactory;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Protocol;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Status;
import de.ugoe.cs.util.console.Console;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class ExchangeListener {
    private HttpMonitorExchangeHandler exchangeHandler;
    private HttpServletRequest request;
    private List<ByteBuffer> requestData = new LinkedList<ByteBuffer>();
    private HttpServletResponse response;
    private List<ByteBuffer> responseData = new LinkedList<ByteBuffer>();
    private long lastUpdate = System.currentTimeMillis();

    ExchangeListener(HttpMonitorExchangeHandler exchangeHandler) {
        this.exchangeHandler = exchangeHandler;
    }

    public void onRequest(HttpServletRequest request) throws IllegalStateException {
        Console.traceln((Level)Level.FINEST, (String)(this + ": onRequest " + request));
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        this.lastUpdate = System.currentTimeMillis();
        this.request = request;
    }

    public void onRequestContent(ByteBuffer data) {
        Console.traceln((Level)Level.FINEST, (String)(this + ": onRequestContent " + data));
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.lastUpdate = System.currentTimeMillis();
        this.requestData.add(data);
    }

    public void onResponse(HttpServletResponse response) {
        Console.traceln((Level)Level.FINEST, (String)(this + ": onResponse " + response));
        if (response == null) {
            throw new IllegalArgumentException("response must not be null");
        }
        this.lastUpdate = System.currentTimeMillis();
        this.response = response;
    }

    public void onResponseContent(ByteBuffer data) {
        Console.traceln((Level)Level.FINEST, (String)(this + ": onResponseContent " + data));
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.lastUpdate = System.currentTimeMillis();
        this.responseData.add(data);
    }

    public void onFinish(Status status) {
        Console.traceln((Level)Level.FINEST, (String)(this + ": onFinish " + status));
        if (status == null) {
            throw new IllegalArgumentException("status must not be null");
        }
        this.lastUpdate = System.currentTimeMillis();
        this.sendToExchangeHandler(status);
    }

    HttpServletRequest getRequest() {
        return this.request;
    }

    long getLastUpdate() {
        return this.lastUpdate;
    }

    private void sendToExchangeHandler(Status status) {
        ObjectFactory eventObjectFactory = new ObjectFactory();
        HttpExchange exchange = eventObjectFactory.createHttpExchange();
        exchange.setStatus(status);
        Address address = eventObjectFactory.createAddress();
        address.setIp(this.request.getRemoteAddr());
        address.setHost(this.request.getRemoteHost());
        address.setPort(BigInteger.valueOf(this.request.getRemotePort()));
        exchange.setSender(address);
        address = eventObjectFactory.createAddress();
        address.setIp(this.request.getLocalAddr());
        address.setHost(this.request.getLocalName());
        address.setPort(BigInteger.valueOf(this.request.getLocalPort()));
        exchange.setReceiver(address);
        exchange.setRequest(this.map(this.request, eventObjectFactory));
        exchange.setResponse(this.map(this.response, eventObjectFactory));
        this.exchangeHandler.handleHttpExchange(exchange);
    }

    private HttpRequest map(HttpServletRequest request, ObjectFactory eventObjectFactory) {
        HttpRequest eventRequest = eventObjectFactory.createHttpRequest();
        eventRequest.setMethod(Method.fromValue((String)request.getMethod()));
        eventRequest.setProtocol(Protocol.fromValue((String)request.getProtocol()));
        eventRequest.setUrl(request.getRequestURL().toString());
        eventRequest.setQuery(request.getQueryString());
        Headers headers = eventObjectFactory.createHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                Header header = eventObjectFactory.createHeader();
                header.setKey(headerName);
                header.setValue((String)headerValues.nextElement());
                headers.getHeader().add(header);
            }
        }
        eventRequest.setHeaders(headers);
        if (request.getCookies() != null) {
            Cookies cookies = eventObjectFactory.createCookies();
            javax.servlet.http.Cookie[] cookieArray = request.getCookies();
            int n = cookieArray.length;
            int n2 = 0;
            while (n2 < n) {
                javax.servlet.http.Cookie requestCookie = cookieArray[n2];
                Cookie cookie = eventObjectFactory.createCookie();
                cookie.setComment(requestCookie.getComment());
                cookie.setDomain(requestCookie.getDomain());
                cookie.setIsHttpOnly(Boolean.valueOf(requestCookie.isHttpOnly()));
                cookie.setIsSecure(Boolean.valueOf(requestCookie.getSecure()));
                cookie.setMaxAge(BigInteger.valueOf(requestCookie.getMaxAge()));
                cookie.setName(requestCookie.getName());
                cookie.setPath(requestCookie.getPath());
                cookie.setValue(requestCookie.getValue());
                cookie.setVersion(BigInteger.valueOf(requestCookie.getVersion()));
                cookies.getCookie().add(cookie);
                ++n2;
            }
            eventRequest.setCookies(cookies);
        }
        eventRequest.setAuthType(request.getAuthType());
        eventRequest.setRemoteUser(request.getRemoteUser());
        eventRequest.setRequestedSessionId(request.getRequestedSessionId());
        if (this.requestData.size() > 0) {
            Content content = eventObjectFactory.createContent();
            content.setEncoding(request.getCharacterEncoding());
            content.setType(request.getContentType());
            content.setLength((long)request.getContentLength());
            content.setData(this.createString(this.requestData));
            eventRequest.setContent(content);
        }
        return eventRequest;
    }

    private HttpResponse map(HttpServletResponse response, ObjectFactory eventObjectFactory) {
        HttpResponse eventResponse = eventObjectFactory.createHttpResponse();
        eventResponse.setStatus(BigInteger.valueOf(response.getStatus()));
        Headers headers = eventObjectFactory.createHeaders();
        Collection headerNames = response.getHeaderNames();
        for (String headerName : headerNames) {
            Collection headerValues = response.getHeaders(headerName);
            for (String headerValue : headerValues) {
                Header header = eventObjectFactory.createHeader();
                header.setKey(headerName);
                header.setValue(headerValue);
                headers.getHeader().add(header);
            }
        }
        eventResponse.setHeaders(headers);
        if (this.responseData.size() > 0) {
            Content content = eventObjectFactory.createContent();
            content.setEncoding(response.getCharacterEncoding());
            content.setType(response.getContentType());
            String data = this.createString(this.responseData);
            content.setLength((long)data.length());
            content.setData(data);
            eventResponse.setContent(content);
        }
        return eventResponse;
    }

    private String createString(List<ByteBuffer> bufferList) {
        StringBuffer str = new StringBuffer();
        for (ByteBuffer buffer : bufferList) {
            while (buffer.hasRemaining()) {
                str.append((char)buffer.get());
            }
        }
        return str.toString();
    }
}

