/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.httpmonitor;

import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorComponent;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorException;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorExchangeHandler;
import de.ugoe.cs.autoquest.httpmonitor.exchange.HttpExchange;
import de.ugoe.cs.autoquest.httpmonitor.exchange.ObjectFactory;
import de.ugoe.cs.util.console.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class HttpMonitorOutputWriter
implements HttpMonitorComponent,
HttpMonitorExchangeHandler {
    private static final int MAXIMUM_LOG_FILE_SIZE = 50000000;
    private static final String DEFAULT_LOG_FILE_BASE_DIR = "logs";
    private File logFileBaseDir;
    private File logFile;
    private PrintWriter outputWriter;
    private long lastUpdate;

    public HttpMonitorOutputWriter(String logFileBaseDir) {
        this.logFileBaseDir = logFileBaseDir == null ? new File(DEFAULT_LOG_FILE_BASE_DIR) : new File(logFileBaseDir);
        this.lastUpdate = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() throws HttpMonitorException {
        if (this.outputWriter != null) {
            throw new IllegalStateException("already initialized. Call close() first");
        }
        Class<HttpMonitorOutputWriter> clazz = HttpMonitorOutputWriter.class;
        synchronized (HttpMonitorOutputWriter.class) {
            try {
                if (!this.logFileBaseDir.exists()) {
                    if (!this.logFileBaseDir.mkdirs()) {
                        throw new HttpMonitorException("log file directory " + this.logFileBaseDir + " can not be created");
                    }
                } else if (!this.logFileBaseDir.isDirectory()) {
                    throw new HttpMonitorException("log file directory " + this.logFileBaseDir + " already exists as a file");
                }
                this.logFile = new File(this.logFileBaseDir, this.getLogFileName(-1));
                if (this.logFile.exists()) {
                    this.rotateLogFile();
                }
                this.createLogWriter();
            }
            catch (IOException e) {
                throw new HttpMonitorException("could not open logfile " + this.logFile, e);
            }
            this.lastUpdate = System.currentTimeMillis();
            return;
        }
    }

    private String getLogFileName(int index) {
        String result = "httpmonitor";
        if (index >= 0) {
            result = String.valueOf(result) + "_" + new DecimalFormat("000").format(index);
        }
        result = String.valueOf(result) + ".log";
        return result;
    }

    @Override
    public synchronized void start() throws IllegalStateException, HttpMonitorException {
        this.lastUpdate = System.currentTimeMillis();
    }

    @Override
    public synchronized void handleHttpExchange(HttpExchange httpExchange) {
        if (this.outputWriter == null) {
            throw new IllegalStateException("not initialized. Call init() first");
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)HttpExchange.class.getPackage().getName());
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal((Object)new ObjectFactory().createHttpExchange(httpExchange), (Writer)this.outputWriter);
        }
        catch (JAXBException e) {
            Console.traceln(Level.WARNING, "could not dump exchange to log file: " + (Object)((Object)e));
            Console.logException((Exception)((Object)e));
        }
        this.outputWriter.flush();
        try {
            this.considerLogRotate();
        }
        catch (IOException e) {
            throw new IllegalStateException("could not perform log rotation: " + e, e);
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    private synchronized void considerLogRotate() throws IOException {
        if (this.logFile.length() > 50000000L) {
            this.closeLogWriter();
            this.rotateLogFile();
            this.createLogWriter();
        }
    }

    private void rotateLogFile() {
        File checkFile;
        File clientLogDir = this.logFile.getParentFile();
        int logFileIndex = -1;
        while ((checkFile = new File(clientLogDir, this.getLogFileName(++logFileIndex))).exists()) {
        }
        if (!this.logFile.renameTo(checkFile)) {
            Console.printerrln("could not rename log file " + this.logFile + " to " + checkFile + ". Will not perform log rotation.");
        } else {
            ++logFileIndex;
            this.logFile = new File(clientLogDir, this.getLogFileName(-1));
        }
    }

    private void createLogWriter() throws IOException {
        FileOutputStream fis = new FileOutputStream(this.logFile);
        this.outputWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fis, "UTF-8"));
        this.outputWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.outputWriter.println("<session xmlns=\"http://autoquest.informatik.uni-goettingen.de\" >");
    }

    private void closeLogWriter() {
        if (this.outputWriter != null) {
            this.outputWriter.println("</session>");
            this.outputWriter.flush();
            this.outputWriter.close();
            this.outputWriter = null;
        }
    }

    @Override
    public synchronized void stop() {
        this.closeLogWriter();
        this.rotateLogFile();
        this.lastUpdate = System.currentTimeMillis();
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }
}

