/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.keyboardmaps;

import java.awt.event.KeyEvent;

public enum VirtualKey {
    ENTER(10),
    BACK_SPACE(8),
    TAB(9),
    CANCEL(3),
    CLEAR(12),
    SHIFT(16),
    CONTROL(17),
    ALT(18),
    PAUSE(19),
    CAPS_LOCK(20),
    ESCAPE(27),
    SPACE(32),
    PAGE_UP(33),
    PAGE_DOWN(34),
    END(35),
    HOME(36),
    LEFT(37),
    UP(38),
    RIGHT(39),
    DOWN(40),
    COMMA(44),
    MINUS(45),
    PERIOD(46),
    SLASH(47),
    DIGIT_0(48),
    DIGIT_1(49),
    DIGIT_2(50),
    DIGIT_3(51),
    DIGIT_4(52),
    DIGIT_5(53),
    DIGIT_6(54),
    DIGIT_7(55),
    DIGIT_8(56),
    DIGIT_9(57),
    SEMICOLON(59),
    EQUALS(61),
    LETTER_A(65),
    LETTER_B(66),
    LETTER_C(67),
    LETTER_D(68),
    LETTER_E(69),
    LETTER_F(70),
    LETTER_G(71),
    LETTER_H(72),
    LETTER_I(73),
    LETTER_J(74),
    LETTER_K(75),
    LETTER_L(76),
    LETTER_M(77),
    LETTER_N(78),
    LETTER_O(79),
    LETTER_P(80),
    LETTER_Q(81),
    LETTER_R(82),
    LETTER_S(83),
    LETTER_T(84),
    LETTER_U(85),
    LETTER_V(86),
    LETTER_W(87),
    LETTER_X(88),
    LETTER_Y(89),
    LETTER_Z(90),
    OPEN_BRACKET(91),
    BACK_SLASH(92),
    CLOSE_BRACKET(93),
    NUMPAD_0(96),
    NUMPAD_1(97),
    NUMPAD_2(98),
    NUMPAD_3(99),
    NUMPAD_4(100),
    NUMPAD_5(101),
    NUMPAD_6(102),
    NUMPAD_7(103),
    NUMPAD_8(104),
    NUMPAD_9(105),
    MULTIPLY(106),
    ADD(107),
    SEPARATOR(108),
    SUBTRACT(109),
    DECIMAL(110),
    DIVIDE(111),
    DELETE(127),
    NUM_LOCK(144),
    SCROLL_LOCK(145),
    F1(112),
    F2(113),
    F3(114),
    F4(115),
    F5(116),
    F6(117),
    F7(118),
    F8(119),
    F9(120),
    F10(121),
    F11(122),
    F12(123),
    F13(61440),
    F14(61441),
    F15(61442),
    F16(61443),
    F17(61444),
    F18(61445),
    F19(61446),
    F20(61447),
    F21(61448),
    F22(61449),
    F23(61450),
    F24(61451),
    PRINTSCREEN(154),
    INSERT(155),
    HELP(156),
    META(157),
    BACK_QUOTE(192),
    QUOTE(222),
    KP_UP(224),
    KP_DOWN(225),
    KP_LEFT(226),
    KP_RIGHT(227),
    DEAD_GRAVE(128),
    DEAD_ACUTE(129),
    DEAD_CIRCUMFLEX(130),
    DEAD_TILDE(131),
    DEAD_MACRON(132),
    DEAD_BREVE(133),
    DEAD_ABOVEDOT(134),
    DEAD_DIAERESIS(135),
    DEAD_ABOVERING(136),
    DEAD_DOUBLEACUTE(137),
    DEAD_CARON(138),
    DEAD_CEDILLA(139),
    DEAD_OGONEK(140),
    DEAD_IOTA(141),
    DEAD_VOICED_SOUND(142),
    DEAD_SEMIVOICED_SOUND(143),
    AMPERSAND(150),
    ASTERISK(151),
    QUOTEDBL(152),
    LESS(153),
    GREATER(160),
    BRACELEFT(161),
    BRACERIGHT(162),
    AT(512),
    COLON(513),
    CIRCUMFLEX(514),
    DOLLAR(515),
    EURO_SIGN(516),
    EXCLAMATION_MARK(517),
    INVERTED_EXCLAMATION_MARK(518),
    LEFT_PARENTHESIS(519),
    NUMBER_SIGN(520),
    PLUS(521),
    RIGHT_PARENTHESIS(522),
    UNDERSCORE(523),
    WINDOWS(524),
    CONTEXT_MENU(525),
    FINAL(24),
    CONVERT(28),
    NONCONVERT(29),
    ACCEPT(30),
    MODECHANGE(31),
    KANA(21),
    KANJI(25),
    ALPHANUMERIC(240),
    KATAKANA(241),
    HIRAGANA(242),
    FULL_WIDTH(243),
    HALF_WIDTH(244),
    ROMAN_CHARACTERS(245),
    ALL_CANDIDATES(256),
    PREVIOUS_CANDIDATE(257),
    CODE_INPUT(258),
    JAPANESE_KATAKANA(259),
    JAPANESE_HIRAGANA(260),
    JAPANESE_ROMAN(261),
    KANA_LOCK(262),
    INPUT_METHOD_ON_OFF(263),
    CUT(65489),
    COPY(65485),
    PASTE(65487),
    UNDO(65483),
    AGAIN(65481),
    FIND(65488),
    PROPS(65482),
    STOP(65480),
    COMPOSE(65312),
    ALT_GRAPH(65406),
    BEGIN(65368),
    UNDEFINED(0);

    private int virtualKeyCode = -1;
    private String description;

    private VirtualKey(int virtualKeyCode) {
        this.virtualKeyCode = virtualKeyCode;
        this.description = KeyEvent.getKeyText(this.virtualKeyCode);
    }

    String getDescription() {
        return this.description;
    }

    public boolean isCombinationKey() {
        switch (this) {
            case SHIFT: 
            case CONTROL: 
            case ALT: 
            case WINDOWS: 
            case ALT_GRAPH: {
                return true;
            }
        }
        return false;
    }

    public boolean isLockKey() {
        switch (this) {
            case CAPS_LOCK: 
            case NUM_LOCK: 
            case SCROLL_LOCK: {
                return true;
            }
        }
        return false;
    }

    public boolean isShiftKey() {
        switch (this) {
            case SHIFT: {
                return true;
            }
        }
        return false;
    }

    public boolean isAltKey() {
        switch (this) {
            case ALT: 
            case ALT_GRAPH: {
                return true;
            }
        }
        return false;
    }

    public boolean isControlKey() {
        switch (this) {
            case CONTROL: {
                return true;
            }
        }
        return false;
    }

    public boolean isWindowsKey() {
        switch (this) {
            case WINDOWS: {
                return true;
            }
        }
        return false;
    }

    public boolean isMetaKey() {
        switch (this) {
            case META: {
                return true;
            }
        }
        return false;
    }

    public boolean isLetter() {
        if (this.virtualKeyCode > -1) {
            return Character.isLetter((char)this.virtualKeyCode);
        }
        return false;
    }

    public boolean isDigit() {
        if (this.virtualKeyCode > -1) {
            return Character.isDigit(this.virtualKeyCode);
        }
        return false;
    }

    public static VirtualKey parseVirtualKey(String string) {
        int virtualKeyCode = Integer.parseInt(string);
        VirtualKey[] virtualKeyArray = VirtualKey.values();
        int n = virtualKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualKey key1 = virtualKeyArray[n2];
            if (key1.virtualKeyCode == virtualKeyCode) {
                return key1;
            }
            ++n2;
        }
        throw new IllegalArgumentException("there is no virtual key with id " + string);
    }

    public static VirtualKey valueOf(String string) {
        return Enum.valueOf(VirtualKey.class, string);
    }
}

