#pragma once

#include "WindowData.h"
#include <map>
#include <vector>

BOOL CALLBACK EnumChildren(HWND hwnd, LPARAM lParam);

class WindowFinder
{
private:
	WindowData * currentWindow;

	std::vector<std::pair<HWND,int>> * scores;

	std::vector<HWND> * parentHandles;

	int maxScore;

	bool evalPopup;

	bool success;

	std::wstring errorMessage;

public:
	WindowFinder(void);
	~WindowFinder(void);

	HWND find(WindowData * winData);

	void setEqualityScore(HWND hwnd, int resourceId, wchar_t * windowName, wchar_t * className);

	bool isCurrentPopup();

	bool successfull();

	std::wstring getErrorMessage();

};
