//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.usability2.rules.patterns;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.usability.EvaluationMethodCaller;
import de.ugoe.cs.autoquest.usability.result.UsabilityProblemDescription;
import de.ugoe.cs.autoquest.usability.result.UsabilityProblemDescriptionResolver;
import de.ugoe.cs.autoquest.usability.rules.UsabilityRule;
import de.ugoe.cs.autoquest.usability.rules.UsabilityUsageProblem;
import de.ugoe.cs.autoquest.plugin.usability2.statistics.Histogramm;
import de.ugoe.cs.autoquest.plugin.usability2.tools.TaskUtilities;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIterationInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;

/**
 * <p>
 * Test Rule to see if new pattern method may be used for problem checking
 * </p>
 * 
 * @author Konni Hartmann
 */
public class TestProblem extends UsabilityRule implements UsabilityUsageProblem {

    /**
     * <p>
     * TODO: comment
     * </p>
     * 
     * @param taskTree
     */
    public TestProblem(ITaskModel taskModel) {
        super(taskModel);
        this.name = "PatternProblem";
        this.defect = new UsabilityProblemDescriptionResolver().descriptionFor("PatternProblem");
        initUsagePattern();
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     * 
     */
    private void initUsagePattern() {}

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.usability.rules.UsabilityRule#check()
     */
    @Override
    public Optional<UsabilityProblemDescription> check() {
        Optional<UsabilityProblemDescription> present = Optional.absent();

        System.out.println("--");
        System.out.println("TEST-RUN:");

        for (ITask task : TaskUtilities.findRootTasks(taskModel.getTasks())) {

            if (task instanceof IIteration) {

                Histogramm hist = new Histogramm();
                for (ITaskInstance instance : task.getInstances()) {

                    if (instance instanceof IIterationInstance) {
                        int cnt = ((IIterationInstance) instance).getChildren().size();
                        hist.add(cnt);
                    }
                }

                int total = hist.count();
                int rTotal = hist.removeLessThan(1).count(-1);
                System.out.printf("%s [%d | %d]\n", task.getDescription(), total, rTotal);

            }
        }

        System.out.println("Finished TEST");
        return present;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.autoquest.usability.rules.UsabilityRule#callEvaluationMetho(de.ugoe.cs.autoquest
     * .usability.EvaluationMethodCaller)
     */
    @Override
    public Optional<UsabilityProblemDescription> callEvaluationMethod(EvaluationMethodCaller evaluationMethodCaller)
    {
        return evaluationMethodCaller.check(this);
    }
}
