/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.eventcore.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.GUIElementFactory;
import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModelException;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementFactory;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GUIElementTree<T> {
    private Map<T, IGUIElement> guiElements;
    private Map<T, IGUIElementSpec> guiElementSpecs;
    private Map<T, List<T>> childRelations;
    private Map<T, T> parentRelations;
    private GUIModel guiModel;
    private IGUIElementFactory guiElementFactory = GUIElementFactory.getInstance();

    public GUIElementTree() {
        this.guiElementSpecs = new HashMap<T, IGUIElementSpec>();
        this.childRelations = new HashMap<T, List<T>>();
        this.parentRelations = new HashMap<T, T>();
        this.guiElements = new HashMap<T, IGUIElement>();
        this.guiModel = new GUIModel();
    }

    public GUIElementTree(GUIModel guiModel) {
        this.guiElementSpecs = new HashMap<T, IGUIElementSpec>();
        this.childRelations = new HashMap<T, List<T>>();
        this.parentRelations = new HashMap<T, T>();
        this.guiElements = new HashMap<T, IGUIElement>();
        this.guiModel = guiModel;
    }

    public void add(T guiElementID, T parentID, IGUIElementSpec guiElementSpec) throws GUIModelException {
        IGUIElement guiElement = this.guiElements.get(guiElementID);
        if (guiElement == null) {
            IGUIElementSpec parent = this.guiElementSpecs.get(parentID);
            if (parent != null) {
                List<T> otherChildren = this.childRelations.get(parentID);
                if (otherChildren == null) {
                    otherChildren = new ArrayList<T>();
                    this.childRelations.put(parentID, otherChildren);
                }
                otherChildren.add(guiElementID);
                this.parentRelations.put(guiElementID, parentID);
            }
            this.guiElementSpecs.put(guiElementID, guiElementSpec);
            ArrayList<IGUIElementSpec> guiElementPath = new ArrayList<IGUIElementSpec>();
            T currentElementID = guiElementID;
            while (guiElementSpec != null) {
                guiElementPath.add(0, guiElementSpec);
                currentElementID = this.parentRelations.get(currentElementID);
                guiElementSpec = this.guiElementSpecs.get(currentElementID);
            }
            guiElement = this.guiModel.integratePath(guiElementPath, this.guiElementFactory);
            this.guiElements.put(guiElementID, guiElement);
        }
    }

    public IGUIElement find(T id) {
        return this.guiElements.get(id);
    }

    public T find(IGUIElement guiElement) {
        for (Map.Entry<T, IGUIElement> entry : this.guiElements.entrySet()) {
            if (!guiElement.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public int remove(T id) {
        int removedCounter = 0;
        IGUIElementSpec node = this.guiElementSpecs.remove(id);
        if (node != null) {
            List<T> children;
            T parent;
            ++removedCounter;
            List<T> nodesToBeRemoved = this.childRelations.remove(id);
            if (nodesToBeRemoved != null) {
                int i = 0;
                while (i < nodesToBeRemoved.size()) {
                    T nodeToBeRemoved = nodesToBeRemoved.get(i);
                    List<T> children2 = this.childRelations.remove(nodeToBeRemoved);
                    if (children2 != null) {
                        nodesToBeRemoved.addAll(children2);
                    }
                    this.guiElementSpecs.remove(nodeToBeRemoved);
                    this.parentRelations.remove(nodeToBeRemoved);
                    ++removedCounter;
                    ++i;
                }
            }
            if ((parent = this.parentRelations.remove(id)) != null && (children = this.childRelations.get(parent)) != null) {
                int i = 0;
                while (i < children.size()) {
                    if (children.get(i) == id) {
                        children.remove(i);
                        break;
                    }
                    ++i;
                }
                if (children.size() <= 0) {
                    this.childRelations.remove(parent);
                }
            }
        }
        return removedCounter;
    }

    public GUIModel getGUIModel() {
        return this.guiModel;
    }

    public int size() {
        return this.guiElementSpecs.size();
    }
}

