/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.plugin.http;

import de.ugoe.cs.autoquest.httpmonitor.exchange.Address;

public class HTTPUtils {
    public static String toString(Address address) {
        if (address != null) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "";
            if (address.getHost() != null) {
                buffer.append(address.getHost());
                prefix = ":";
            } else if (address.getIp() != null) {
                buffer.append(prefix);
                buffer.append(address.getIp());
                prefix = ":";
            }
            if (address.getPort() != null) {
                buffer.append(prefix);
                buffer.append(address.getPort());
            }
            if (buffer.length() > 0) {
                return buffer.toString();
            }
        }
        return null;
    }

    public static boolean equals(Address address1, Address address2) {
        if (address1 == null) {
            return address2 == null;
        }
        if (address2 == null) {
            return false;
        }
        if (!HTTPUtils.equals(address1.getPort(), address2.getPort())) {
            return false;
        }
        if (address1.getIp() != null) {
            return HTTPUtils.equals(address1.getIp(), address2.getIp());
        }
        return HTTPUtils.equals(address1.getHost(), address2.getHost());
    }

    public static <T> boolean equals(T object1, T object2) {
        if (object1 == null) {
            return object2 == null;
        }
        return object1.equals(object2);
    }

    private HTTPUtils() {
    }
}

