/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.plugin.http;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Content;
import de.ugoe.cs.autoquest.httpmonitor.exchange.HttpExchange;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Session;
import de.ugoe.cs.autoquest.plugin.http.eventcore.HTTPEventType;
import de.ugoe.cs.autoquest.plugin.http.eventcore.HTTPTarget;
import de.ugoe.cs.autoquest.plugin.http.eventcore.SOAPEventType;
import de.ugoe.cs.util.console.Console;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class HTTPLogParser {
    private Collection<List<Event>> sequences = new LinkedList<List<Event>>();
    private MessageFactory soapMessageFactory;

    public void parseFile(String filename) throws JAXBException {
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        this.parseFile(new File(filename));
    }

    public void parseFile(File file) throws JAXBException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        try {
            this.parseFile(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            Console.printerr((String)("Error parsing file + " + file.getName()));
            Console.logException((Exception)e);
            return;
        }
    }

    public void parseFile(InputStream stream) throws JAXBException {
        StreamSource source;
        if (stream == null) {
            throw new IllegalArgumentException("stream must not be null");
        }
        JAXBContext jc = JAXBContext.newInstance((String)Session.class.getPackage().getName());
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        JAXBElement sessionObj = (JAXBElement)unmarshaller.unmarshal((Source)(source = new StreamSource(stream)));
        Session session = (Session)sessionObj.getValue();
        if (session.getHttpExchange() != null && session.getHttpExchange().size() > 0) {
            LinkedList<Event> sequence = new LinkedList<Event>();
            for (HttpExchange exchange : session.getHttpExchange()) {
                sequence.add(new Event(this.createEvent(exchange), (IEventTarget)new HTTPTarget(exchange.getReceiver())));
            }
            this.sequences.add(sequence);
        }
    }

    private IEventType createEvent(HttpExchange exchange) {
        Content requestContent = exchange.getRequest() != null ? exchange.getRequest().getContent() : null;
        SOAPMessage soapRequest = this.getSOAPMessage(requestContent);
        Content responseContent = exchange.getResponse() != null ? exchange.getResponse().getContent() : null;
        SOAPMessage soapResponse = this.getSOAPMessage(responseContent);
        if (soapRequest != null) {
            return new SOAPEventType(exchange, soapRequest, soapResponse);
        }
        return new HTTPEventType(exchange);
    }

    private SOAPMessage getSOAPMessage(Content content) {
        block5: {
            if (content != null && content.getData() != null) {
                try {
                    String encoding;
                    if (this.soapMessageFactory == null) {
                        this.soapMessageFactory = MessageFactory.newInstance();
                    }
                    if ((encoding = content.getEncoding()) == null) {
                        encoding = "UTF-8";
                    }
                    ByteArrayInputStream in = new ByteArrayInputStream(content.getData().getBytes(encoding));
                    return this.soapMessageFactory.createMessage(null, (InputStream)in);
                }
                catch (Exception e) {
                    if (content.getData().toLowerCase().indexOf("envelope") <= 0) break block5;
                    Console.traceln((Level)Level.WARNING, (String)("HTTP message seems to be a SOAP message but it could not be parsed as such: " + e));
                    Console.logException((Exception)e);
                }
            }
        }
        return null;
    }

    public Collection<List<Event>> getSequences() {
        return this.sequences;
    }
}

