//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.guitar.commands;

import java.util.List;

import de.ugoe.cs.autoquest.plugin.guitar.EFGModelGenerator;
import de.ugoe.cs.autoquest.usageprofiles.FirstOrderMarkovModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to that loads an EFG and creates a first-order Markov model with the
 * same structure.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDefgToMM implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		String modelname;
		try {
			filename = (String) parameters.get(0);
			modelname = (String) parameters.get(1);
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

		EFGModelGenerator modelGenerator = new EFGModelGenerator();
		FirstOrderMarkovModel model = modelGenerator
				.efgToFirstOrderMarkovModel(filename);
		GlobalDataContainer.getInstance().addData(modelname, model);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "efgToMM <filename> <modelname>";
	}

}
