/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.util;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class StopWatch {
    private Map<String, Split> mSplits = new HashMap<String, Split>();

    public void start(String id) throws IllegalStateException {
        Split split = this.mSplits.get(id);
        if (split == null) {
            split = new Split(id);
            this.mSplits.put(id, split);
        }
        split.start();
    }

    public void stop(String id) throws IllegalStateException, IllegalArgumentException {
        Split split = this.mSplits.get(id);
        if (split == null) {
            throw new IllegalArgumentException("split with id " + id + " does not exist");
        }
        split.stop();
    }

    public long getDuration(String id) throws IllegalArgumentException {
        Split split = this.mSplits.get(id);
        if (split == null) {
            throw new IllegalArgumentException("split with id " + id + " does not exist");
        }
        if (split.isRunning()) {
            split.stop();
        }
        return split.getDuration();
    }

    public void reset() {
        this.mSplits.clear();
    }

    public void dumpStatistics(PrintStream out) {
        if (this.mSplits.size() <= 0) {
            throw new IllegalStateException("no splits registered that could be dumped");
        }
        HashMap<String, Long> durations = new HashMap<String, Long>();
        for (String id : this.mSplits.keySet()) {
            durations.put(id, this.getDuration(id));
        }
        LinkedList<String> sortedIds = new LinkedList<String>();
        int maxIdLength = 0;
        for (Map.Entry entry : durations.entrySet()) {
            boolean added = false;
            int i = 0;
            while (i < sortedIds.size()) {
                if ((Long)durations.get(sortedIds.get(i)) >= (Long)entry.getValue()) {
                    sortedIds.add(i, (String)entry.getKey());
                    added = true;
                    break;
                }
                ++i;
            }
            if (!added) {
                sortedIds.add((String)entry.getKey());
            }
            maxIdLength = Math.max(maxIdLength, ((String)entry.getKey()).length());
        }
        String id = (String)sortedIds.get(sortedIds.size() - 1);
        Split longestWatch = this.mSplits.get(id);
        boolean longestDurationCoversOthers = true;
        for (Map.Entry<String, Split> watch : this.mSplits.entrySet()) {
            if (watch.getValue().getFirstStart() >= longestWatch.getFirstStart() && watch.getValue().getLastStop() <= longestWatch.getLastStop()) continue;
            longestDurationCoversOthers = false;
            break;
        }
        out.println();
        out.println("Watch Statistics");
        out.println("================");
        for (String sortedId : sortedIds) {
            out.print(sortedId);
            int i = sortedId.length();
            while (i <= maxIdLength) {
                out.print(' ');
                ++i;
            }
            out.print(": ");
            out.print(durations.get(sortedId));
            out.print(" ms");
            out.print(" (");
            out.print(this.mSplits.get(sortedId).getNoOfStarts());
            out.print(" starts");
            if (longestDurationCoversOthers) {
                out.print(", ");
                out.print(DecimalFormat.getPercentInstance().format((double)((Long)durations.get(sortedId)).longValue() / (double)longestWatch.getDuration()));
                out.print(" of overall duration");
            }
            out.println(')');
        }
        out.println();
    }

    private static class Split {
        private String id;
        private long firstStart = -1L;
        private long lastStart = -1L;
        private long lastStop = -1L;
        private long duration = 0L;
        private long noOfStarts = 0L;

        private Split(String id) {
            this.id = id;
        }

        private void start() throws IllegalStateException {
            if (this.lastStart > -1L) {
                throw new IllegalStateException("split with id " + this.id + " already running");
            }
            this.lastStart = System.currentTimeMillis();
            if (this.firstStart < 0L) {
                this.firstStart = this.lastStart;
            }
            ++this.noOfStarts;
        }

        private boolean isRunning() {
            return this.lastStart > -1L;
        }

        private void stop() throws IllegalStateException {
            if (this.lastStart < 0L) {
                throw new IllegalStateException("split with id " + this.id + " not running");
            }
            this.lastStop = System.currentTimeMillis();
            this.duration += this.lastStop - this.lastStart;
            this.lastStart = -1L;
        }

        private long getFirstStart() {
            return this.firstStart;
        }

        private long getLastStop() {
            return this.lastStop;
        }

        private long getDuration() {
            return this.duration;
        }

        private long getNoOfStarts() {
            return this.noOfStarts;
        }
    }
}

