/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.net.URI;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.B64Code;

public class BasicAuthentication
implements Authentication {
    private final URI uri;
    private final String realm;
    private final String user;
    private final String password;

    public BasicAuthentication(URI uri, String realm, String user, String password) {
        this.uri = uri;
        this.realm = realm;
        this.user = user;
        this.password = password;
    }

    @Override
    public boolean matches(String type, URI uri, String realm) {
        if (!"basic".equalsIgnoreCase(type)) {
            return false;
        }
        if (!uri.toString().startsWith(this.uri.toString())) {
            return false;
        }
        return this.realm.equals(realm);
    }

    @Override
    public Authentication.Result authenticate(Request request, ContentResponse response, Authentication.HeaderInfo headerInfo, Attributes context) {
        String encoding = "ISO-8859-1";
        String value = "Basic " + B64Code.encode((String)(this.user + ":" + this.password), (String)encoding);
        return new BasicResult(headerInfo.getHeader(), this.uri, value);
    }

    private static class BasicResult
    implements Authentication.Result {
        private final HttpHeader header;
        private final URI uri;
        private final String value;

        public BasicResult(HttpHeader header, URI uri, String value) {
            this.header = header;
            this.uri = uri;
            this.value = value;
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public void apply(Request request) {
            request.header(this.header, this.value);
        }

        public String toString() {
            return String.format("Basic authentication result for %s", this.uri);
        }
    }
}

