/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpConnectionOverHTTP
extends AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(HttpConnectionOverHTTP.class);
    private final Delegate delegate;
    private final HttpChannelOverHTTP channel;
    private boolean closed;
    private long idleTimeout;

    public HttpConnectionOverHTTP(EndPoint endPoint, HttpDestination destination) {
        super(endPoint, destination.getHttpClient().getExecutor(), destination.getHttpClient().isDispatchIO());
        this.delegate = new Delegate(destination);
        this.channel = new HttpChannelOverHTTP(this);
    }

    public HttpChannelOverHTTP getHttpChannel() {
        return this.channel;
    }

    public HttpDestinationOverHTTP getHttpDestination() {
        return (HttpDestinationOverHTTP)this.delegate.getHttpDestination();
    }

    @Override
    public void send(Request request, Response.CompleteListener listener) {
        this.delegate.send(request, listener);
    }

    protected void send(HttpExchange exchange) {
        this.delegate.send(exchange);
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onClose() {
        this.closed = true;
        super.onClose();
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected boolean onReadTimeout() {
        LOG.debug("{} idle timeout", new Object[]{this});
        HttpExchange exchange = this.channel.getHttpExchange();
        if (exchange != null) {
            return exchange.getRequest().abort(new TimeoutException());
        }
        this.getHttpDestination().remove(this);
        return true;
    }

    public void onFillable() {
        HttpExchange exchange = this.channel.getHttpExchange();
        if (exchange != null) {
            this.channel.receive();
        } else {
            this.close();
        }
    }

    public void release() {
        this.getEndPoint().setIdleTimeout(this.idleTimeout);
        this.getHttpDestination().release(this);
    }

    @Override
    public void close() {
        this.getHttpDestination().remove(this);
        this.getEndPoint().shutdownOutput();
        LOG.debug("{} oshut", new Object[]{this});
        this.getEndPoint().close();
        LOG.debug("{} closed", new Object[]{this});
    }

    public String toString() {
        return String.format("%s@%x(l:%s <-> r:%s)", HttpConnection.class.getSimpleName(), this.hashCode(), this.getEndPoint().getLocalAddress(), this.getEndPoint().getRemoteAddress());
    }

    private class Delegate
    extends HttpConnection {
        private Delegate(HttpDestination destination) {
            super(destination);
        }

        @Override
        protected void send(HttpExchange exchange) {
            Request request = exchange.getRequest();
            this.normalizeRequest(request);
            EndPoint endPoint = HttpConnectionOverHTTP.this.getEndPoint();
            HttpConnectionOverHTTP.this.idleTimeout = endPoint.getIdleTimeout();
            endPoint.setIdleTimeout(request.getIdleTimeout());
            HttpConnectionOverHTTP.this.channel.associate(exchange);
            HttpConnectionOverHTTP.this.channel.send();
        }

        @Override
        public void close() {
            HttpConnectionOverHTTP.this.close();
        }
    }
}

