/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.httpmonitor.proxy;

import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorComponent;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorException;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorExchangeHandler;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Status;
import de.ugoe.cs.autoquest.httpmonitor.proxy.ExchangeListener;
import de.ugoe.cs.util.console.Console;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class ExchangeListenerManager
implements HttpMonitorComponent {
    private static final int SESSION_TIMEOUT = 600000;
    private HttpMonitorExchangeHandler exchangeHandler;
    private Map<HttpServletRequest, ExchangeListener> listeners;
    private Timer listenerTimer;

    ExchangeListenerManager(HttpMonitorExchangeHandler exchangeHandler) {
        this.exchangeHandler = exchangeHandler;
    }

    @Override
    public synchronized void init() throws IllegalStateException, HttpMonitorException {
        Console.traceln(Level.FINER, "initializing exchange listener manager");
        if (this.listeners != null) {
            throw new IllegalStateException("already initialized");
        }
        this.listeners = new HashMap<HttpServletRequest, ExchangeListener>();
        this.listenerTimer = new Timer();
    }

    @Override
    public synchronized void start() throws IllegalStateException, HttpMonitorException {
        Console.traceln(Level.FINER, "starting exchange listener manager");
        if (this.listeners == null) {
            throw new IllegalStateException("not initialized");
        }
        this.listenerTimer.schedule((TimerTask)new ListenerMonitorTimerTask(), 300000L, 300000L);
    }

    @Override
    public synchronized void stop() {
        Console.traceln(Level.FINER, "stopping exchange listener manager");
        if (this.listenerTimer != null) {
            this.listenerTimer.cancel();
        }
        if (this.listeners != null) {
            for (ExchangeListener listener : this.listeners.values()) {
                listener.onFinish(Status.TIMEOUT);
            }
        }
        this.listeners = null;
    }

    public void onRequest(HttpServletRequest request) throws IllegalStateException {
        this.ensureListener(request).onRequest(request);
    }

    public void onRequestContent(HttpServletRequest request, ByteBuffer data) throws IllegalStateException {
        this.ensureListener(request).onRequestContent(data);
    }

    public void onResponse(HttpServletRequest request, HttpServletResponse response) throws IllegalStateException {
        this.ensureListener(request).onResponse(response);
    }

    public void onResponseContent(HttpServletRequest request, ByteBuffer data) throws IllegalStateException {
        this.ensureListener(request).onResponseContent(data);
    }

    public void onFinish(HttpServletRequest request, Status status) throws IllegalStateException {
        this.ensureListener(request).onFinish(status);
        Console.traceln(Level.FINEST, "removing exchange listener for " + request);
        this.listeners.remove(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExchangeListener ensureListener(HttpServletRequest request) {
        ExchangeListener listener = this.listeners.get(request);
        if (listener == null) {
            ExchangeListenerManager exchangeListenerManager = this;
            synchronized (exchangeListenerManager) {
                listener = this.listeners.get(request);
                if (listener == null) {
                    Console.traceln(Level.FINEST, "creating exchange listener for " + request);
                    listener = new ExchangeListener(this.exchangeHandler);
                    this.listeners.put(request, listener);
                }
            }
        }
        return listener;
    }

    public class ListenerMonitorTimerTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExchangeListenerManager exchangeListenerManager = ExchangeListenerManager.this;
            synchronized (exchangeListenerManager) {
                ExchangeListener listener;
                ArrayList<HttpServletRequest> timeoutRequests = new ArrayList<HttpServletRequest>();
                for (Map.Entry entry : ExchangeListenerManager.this.listeners.entrySet()) {
                    listener = (ExchangeListener)entry.getValue();
                    if (System.currentTimeMillis() - listener.getLastUpdate() <= 600000L) continue;
                    timeoutRequests.add((HttpServletRequest)entry.getKey());
                }
                for (HttpServletRequest request : timeoutRequests) {
                    listener = (ExchangeListener)ExchangeListenerManager.this.listeners.remove(request);
                    listener.onFinish(Status.TIMEOUT);
                }
            }
        }
    }
}

