/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.eventcore.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.AbstractDefaultGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class GUIElementGroup
extends AbstractDefaultGUIElement {
    private static final long serialVersionUID = 1L;
    private List<IGUIElement> groupedGUIElements = new LinkedList<IGUIElement>();

    public GUIElementGroup(String groupName, IGUIElement parent, GUIModel guiModel) {
        super(new GroupSpecification(groupName), parent);
        super.setGUIModel(guiModel);
    }

    @Override
    public final void updateSpecification(IGUIElementSpec furtherSpec) {
    }

    @Override
    public String getPlatform() {
        return "none";
    }

    @Override
    public String getStringIdentifier() {
        return ((GroupSpecification)super.getSpecification()).name;
    }

    public String toString() {
        return this.getStringIdentifier();
    }

    public List<IGUIElement> getGroupedElements() {
        return Collections.unmodifiableList(this.groupedGUIElements);
    }

    void addToGroup(IGUIElement guiElement) {
        this.groupedGUIElements.add(guiElement);
    }

    private static class GroupSpecification
    implements IGUIElementSpec {
        private static final long serialVersionUID = 1L;
        private String name;

        private GroupSpecification(String name) {
            this.name = name;
        }

        @Override
        public String getType() {
            return "GUI element group";
        }

        @Override
        public String[] getTypeHierarchy() {
            return new String[]{this.getType()};
        }

        @Override
        public boolean getSimilarity(IGUIElementSpec other) {
            return other instanceof GroupSpecification && this.name.equals(((GroupSpecification)other).name);
        }
    }
}

