/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.eventcore.gui;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.gui.IInteraction;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class TextInput
implements IInteraction {
    private static final long serialVersionUID = 1L;
    private String enteredText;
    private List<Event> textInputEvents;
    private final TextEquality equalityType;

    public TextInput(String enteredText, List<Event> textInputEvents) {
        this(enteredText, textInputEvents, TextEquality.LEXICAL);
    }

    public TextInput(String enteredText, List<Event> textInputEvents, TextEquality equalityType) {
        this.enteredText = enteredText;
        this.textInputEvents = textInputEvents;
        this.equalityType = equalityType;
        if (this.enteredText == null) {
            this.enteredText = "";
        }
        if (this.textInputEvents == null) {
            this.textInputEvents = new LinkedList<Event>();
        }
    }

    @Override
    public String getName() {
        return "TextInput";
    }

    public String toString() {
        return "text input \"" + this.enteredText + "\"";
    }

    public String getEnteredText() {
        return this.enteredText;
    }

    public List<Event> getTextInputEvents() {
        return Collections.unmodifiableList(this.textInputEvents);
    }

    @Override
    public boolean startsLogicalSequence() {
        return false;
    }

    @Override
    public boolean finishesLogicalSequence() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TextInput) {
            switch (this.equalityType) {
                case LEXICAL: {
                    return this.textInputEvents.equals(((TextInput)obj).textInputEvents);
                }
                case SYNTACTICAL: {
                    return this.enteredText.equals(((TextInput)obj).enteredText);
                }
                case SEMANTICAL: {
                    return true;
                }
            }
            throw new AssertionError((Object)"reached source code that should be unreachable");
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.getClass().hashCode();
        if (this.equalityType == TextEquality.LEXICAL) {
            hashCode += this.enteredText.hashCode() + this.textInputEvents.size();
        } else if (this.equalityType == TextEquality.SYNTACTICAL) {
            hashCode += this.enteredText.hashCode();
        }
        return hashCode;
    }

    public static enum TextEquality {
        LEXICAL,
        SYNTACTICAL,
        SEMANTICAL;

    }
}

