//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.util.console.mock.commands;

import java.util.List;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDmockCommand implements Command {

	@Override
	public void run(List<Object> parameters) {
		switch (parameters.size()) {
		case 0:
			Console.println("mock command: run");
			break;
		case 1:
			throw new IllegalArgumentException();
		default:
			throw new RuntimeException();
		}
	}

	@Override
	public String help() {
		return "mock command: help";
	}

}
