package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.TrieBasedModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDprintTrieDot implements Command {
	
	@Override
	public void help() {
		Console.println("Usage: printTreeDot <modelname>");
	}

	@Override
	public void run(List<Object> parameters) {
		String modelname = "";
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		TrieBasedModel model = null; 
		Object dataObject = GlobalDataContainer.getInstance().getData(modelname);
		if( dataObject==null ) {
			Console.println("Model " + modelname + "not found in storage.");
		}
		else if( !(dataObject instanceof TrieBasedModel) ) {
			Console.println("Object " + modelname + " is not a TrieBasedModel!");
		} else {
			model = (TrieBasedModel) dataObject;
			Console.println(model.getTrieDotRepresentation());
		}
	}
	
}
