package de.ugoe.cs.eventbench.web.data;

import java.util.List;

import de.ugoe.cs.eventbench.data.ReplayableEvent;

public class WebEvent extends ReplayableEvent<WebRequest> {

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;
	
	private final long timestamp;
		
	
	private final static String makeType(String path, List<String> postVars, List<String> getVars) {
		String type = path;
		if( getVars!=null && !getVars.isEmpty() ) {
			type += "+GET"+getVars.toString().replace(" ", "");
		}
		if( postVars!=null && !postVars.isEmpty() ) {
			type += "+POST"+postVars.toString().replace(" ", "");
		}
		return type;
	}
	
	public WebEvent(String path, long timestamp, List<String> postVars, List<String> getVars) {
		super(makeType(path, postVars, getVars));
		this.timestamp = timestamp;
		addReplayEvent(new WebRequest(path, postVars, getVars));
	}
	
	public long getTimestamp() {
		return timestamp;
	}

}
