package de.ugoe.cs.eventbench.windows;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.windows.data.WindowTree;
import de.ugoe.cs.util.console.Console;

public class HandlerCreate extends MessageHandler {

	public HandlerCreate() {
		super();
	}

	private String windowName;
	private int hwnd;
	private int parentHwnd;
	private int resourceId;
	private String className;
	private boolean isModal;
	
	@SuppressWarnings("unchecked")
	@Override
	public void onEndElement() {
		if( hwnd!=0 ) {
			WindowTree.getInstance().add(parentHwnd, hwnd, windowName, resourceId, className, isModal);
			
			//store hwnd in GlobalDataContainer to be able to work on with them in DlgInsert
			List<String> listTargets = new ArrayList<String>();
			
			if(GlobalDataContainer.getInstance().getData("ListTargets") == null) {
				GlobalDataContainer.getInstance().addData("ListTargets", listTargets);
			}		
			
			try {
				listTargets = (List<String>) GlobalDataContainer.getInstance().getData("ListTargets");
			}
			catch (ClassCastException e) {
				Console.println("Not able to cast data in GlobalDataContainer to list of targets (String)");
			}
			
			listTargets.add(WindowTree.getInstance().find(hwnd).xmlRepresentation());
		}
	}

	@Override
	public void onParameter(String name, String value) {
		if( name.equals("window.hwnd") ) {
			hwnd = Integer.parseInt(value);
		}
		else if( name.equals("window.name") ) {
			windowName = value;
		}
		else if( name.equals("window.parent.hwnd") ) {
			parentHwnd = Integer.parseInt(value);
		}
		else if( name.equals("window.resourceId") ) {
			resourceId = Integer.parseInt(value);
		}
		else if( name.equals("window.class") ) {
			if( value.startsWith("Afx:") ) {
				className = "Afx:";
			} else {
				className = value;
			}
		}
		else if( name.equals("window.ismodal") ) {
			if( value.equals("true") || value.equals("1") ) {
				isModal = true;
			}
		}
	}

	@Override
	public void onStartElement() {
		windowName = "";
		hwnd = 0;
		parentHwnd = 0;
		resourceId = 0;
		className = "";
		isModal = false;
	}

}
