/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.httpmonitor.proxy;

import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorComponent;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorException;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorExchangeHandler;
import de.ugoe.cs.autoquest.httpmonitor.exchange.HttpExchange;
import de.ugoe.cs.autoquest.httpmonitor.exchange.ObjectFactory;
import de.ugoe.cs.util.console.Console;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.OutputStreamContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class HttpMonitorRemoteExchangeHandler
implements Response.CompleteListener,
HttpMonitorExchangeHandler,
HttpMonitorComponent {
    private HttpClient httpClient;
    private String httpMonitorServer;
    private int httpMonitorPort;
    private Set<Request> openRequests = new HashSet<Request>();

    public HttpMonitorRemoteExchangeHandler(String httpMonitorServer, int httpMonitorPort) {
        this.httpMonitorServer = httpMonitorServer;
        this.httpMonitorPort = httpMonitorPort;
    }

    @Override
    public void init() throws IllegalStateException, HttpMonitorException {
        this.httpClient = this.createHttpClient();
    }

    @Override
    public void start() throws IllegalStateException, HttpMonitorException {
        try {
            this.httpClient.start();
            this.httpClient.getContentDecoderFactories().clear();
        }
        catch (Exception e) {
            throw new HttpMonitorException("could not start client for HTTP-Monitor", e);
        }
    }

    @Override
    public void stop() {
        if (this.httpClient != null) {
            try {
                this.httpClient.stop();
            }
            catch (Exception e) {
                Console.traceln((Level)Level.WARNING, (String)"could not stop client for HTTP-Monitor");
                Console.logException((Exception)e);
            }
        }
        this.httpClient = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleHttpExchange(HttpExchange httpExchange) {
        Set<Request> set = this.openRequests;
        synchronized (set) {
            Request httpMonitorRequest = this.httpClient.newRequest(this.httpMonitorServer, this.httpMonitorPort);
            httpMonitorRequest.method(HttpMethod.POST);
            httpMonitorRequest.version(HttpVersion.HTTP_1_1);
            OutputStreamContentProvider out = new OutputStreamContentProvider();
            httpMonitorRequest.content((ContentProvider)out);
            httpMonitorRequest.send((Response.CompleteListener)this);
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)HttpExchange.class.getPackage().getName());
                Marshaller marshaller = jaxbContext.createMarshaller();
                OutputStreamWriter writer = new OutputStreamWriter(out.getOutputStream(), "UTF-8");
                marshaller.marshal((Object)new ObjectFactory().createHttpExchange(httpExchange), (Writer)writer);
                out.getOutputStream().close();
            }
            catch (JAXBException e) {
                Console.printerrln((String)("could not convert request and response to XML string: " + (Object)((Object)e)));
                Console.logException((Exception)((Object)e));
            }
            catch (IOException e) {
                Console.printerrln((String)("could not close the stream for sending data to the HTML monitor: " + e));
                Console.logException((Exception)e);
            }
            this.openRequests.add(httpMonitorRequest);
            try {
                while (this.openRequests.contains(httpMonitorRequest)) {
                    this.openRequests.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(Result result) {
        if (result.isFailed()) {
            Console.traceln((Level)Level.WARNING, (String)("could not log exchange correctly: " + result.getFailure()));
            Console.logException((Exception)((Exception)result.getFailure()));
        }
        Set<Request> set = this.openRequests;
        synchronized (set) {
            this.openRequests.remove(result.getRequest());
            this.openRequests.notify();
        }
    }

    private HttpClient createHttpClient() {
        HttpClient client = new HttpClient();
        QueuedThreadPool executor = new QueuedThreadPool(10);
        executor.setName("HttpMonitorClients");
        client.setExecutor((Executor)executor);
        client.setMaxConnectionsPerDestination(10000);
        client.setIdleTimeout(30000L);
        client.setConnectTimeout(30000L);
        client.setStopTimeout(30000L);
        client.setRequestBufferSize(0x100000);
        client.setResponseBufferSize(0x100000);
        return client;
    }
}

