/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.eventcore.gui;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.gui.KeyPressed;
import de.ugoe.cs.autoquest.eventcore.gui.KeyReleased;
import de.ugoe.cs.autoquest.eventcore.gui.KeyTyped;
import de.ugoe.cs.autoquest.eventcore.gui.KeyboardFocusChange;
import de.ugoe.cs.autoquest.keyboardmaps.VirtualKey;
import de.ugoe.cs.util.console.Console;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;

public class KeyInteractionCorrector {
    private final CleanupMode mode;

    public KeyInteractionCorrector() {
        this(CleanupMode.ADDITION);
    }

    public KeyInteractionCorrector(CleanupMode mode) {
        this.mode = mode;
    }

    public List<Event> sortKeyInteractions(List<Event> sequence) {
        LinkedList<Event> sortedSequence = new LinkedList<Event>(sequence);
        this.handleIncompleteKeyPairs(sortedSequence);
        this.sortCombinationKeyPairs(sortedSequence);
        return sortedSequence;
    }

    private void sortCombinationKeyPairs(List<Event> sequence) {
        LinkedList<VirtualKey> pressedCombinationKeys = new LinkedList<VirtualKey>();
        int i = 0;
        while (i < sequence.size()) {
            VirtualKey key;
            Event event = sequence.get(i);
            if (event.getType() instanceof KeyPressed && (key = ((KeyPressed)event.getType()).getKey()).isCombinationKey()) {
                pressedCombinationKeys.add(key);
            }
            if (event.getType() instanceof KeyReleased && (key = ((KeyReleased)event.getType()).getKey()).isCombinationKey()) {
                if (key.equals(pressedCombinationKeys.getLast())) {
                    pressedCombinationKeys.removeLast();
                } else {
                    int offset = 1;
                    while (offset + i < sequence.size()) {
                        Event lookaheadEvent = sequence.get(i + offset);
                        if (lookaheadEvent.getType() instanceof KeyReleased && ((KeyReleased)lookaheadEvent.getType()).getKey().equals(pressedCombinationKeys.getLast())) break;
                        ++offset;
                    }
                    sequence.add(i + offset + 1, event);
                    sequence.remove(i);
                    --i;
                }
            }
            ++i;
        }
    }

    private void handleIncompleteKeyPairs(List<Event> sequence) {
        HashSet<VirtualKey> pressedKeys = new HashSet<VirtualKey>();
        int firstPressedIndex = -1;
        HashSet<VirtualKey> pressedCombinationKeysSession = new HashSet<VirtualKey>();
        int i = 0;
        while (i < sequence.size()) {
            block16: {
                VirtualKey key;
                block19: {
                    Event event;
                    block17: {
                        ListIterator<Event> iter;
                        block18: {
                            event = sequence.get(i);
                            if (event.getType() instanceof KeyboardFocusChange && firstPressedIndex != -1) {
                                sequence.remove(i);
                                sequence.add(firstPressedIndex, event);
                            }
                            if (event.getType() instanceof KeyPressed) {
                                if (pressedKeys.isEmpty()) {
                                    firstPressedIndex = i;
                                }
                                if (!(key = ((KeyPressed)event.getType()).getKey()).isCombinationKey()) {
                                    iter = sequence.listIterator(i);
                                    iter.next();
                                    iter.set(new Event(new KeyTyped(key), event.getTarget()));
                                } else {
                                    pressedCombinationKeysSession.add(key);
                                    if (pressedKeys.contains(key)) {
                                        sequence.remove(i);
                                        --i;
                                    }
                                }
                                pressedKeys.add(key);
                            }
                            if (!(event.getType() instanceof KeyReleased)) break block16;
                            key = ((KeyReleased)event.getType()).getKey();
                            if (key.isCombinationKey()) break block17;
                            if (!pressedKeys.contains(key)) break block18;
                            sequence.remove(i);
                            --i;
                            break block19;
                        }
                        switch (this.mode) {
                            case REMOVAL: {
                                sequence.remove(i);
                                --i;
                                break block19;
                            }
                            case ADDITION: {
                                iter = sequence.listIterator(i);
                                iter.next();
                                iter.set(new Event(new KeyTyped(key), event.getTarget()));
                                break block19;
                            }
                            default: {
                                throw new AssertionError((Object)"reached source code that should be unreachable");
                            }
                        }
                    }
                    if (!pressedKeys.contains(key)) {
                        if (pressedCombinationKeysSession.contains(key)) {
                            Console.traceln((Level)Level.SEVERE, (String)("Found a " + key + " KeyReleased event without a KeyPressed event." + "The event will be dropped and the session is possibly faulty."));
                            sequence.remove(i);
                            --i;
                        } else {
                            Console.traceln((Level)Level.SEVERE, (String)("Found a " + key + " KeyReleased event without a KeyPressed event." + "Since no KeyPressed of key " + key + " has been part of the session " + "till now, we assume that the key has been pressed since the beginning " + "of the session and add a KeyPressed event for " + key + " to the start " + "of the session."));
                            sequence.add(0, new Event(new KeyPressed(key), event.getTarget()));
                            ++i;
                        }
                    }
                }
                pressedKeys.remove(key);
                if (pressedKeys.isEmpty()) {
                    firstPressedIndex = -1;
                }
            }
            ++i;
        }
        if (!pressedKeys.isEmpty()) {
            Console.traceln((Level)Level.WARNING, (String)"There was probably a failure during the handling of incomplete key event pairs.");
        }
    }

    public static enum CleanupMode {
        REMOVAL,
        ADDITION;

    }
}

