/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.plugin.http.commands;

import de.ugoe.cs.autoquest.CommandHelpers;
import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.plugin.http.HTTPLogParser;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

public class CMDparseDirHTTP
implements Command {
    public void run(List<Object> parameters) {
        String directory = null;
        String sequencesName = "sequences";
        try {
            directory = (String)parameters.get(0);
            if (parameters.size() >= 2) {
                sequencesName = (String)parameters.get(1);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("missing parameter for directory");
        }
        File folder = new File(directory);
        if (!folder.isDirectory()) {
            Console.printerrln((String)(String.valueOf(directory) + " is not a directory"));
            return;
        }
        HTTPLogParser parser = new HTTPLogParser();
        this.parseFile(folder, parser);
        Collection<List<Event>> sequences = parser.getSequences();
        if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
            CommandHelpers.dataOverwritten((String)sequencesName);
        }
    }

    private void parseFile(File file, HTTPLogParser parser) {
        block4: {
            block3: {
                if (!file.isDirectory()) break block3;
                Object[] children = file.list();
                Arrays.sort(children);
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    File childFile = new File(file, (String)child);
                    this.parseFile(childFile, parser);
                    ++n2;
                }
                break block4;
            }
            if (!file.isFile()) break block4;
            String source = file.getAbsolutePath();
            Console.traceln((Level)Level.INFO, (String)("Processing file: " + source));
            try {
                parser.parseFile(file);
            }
            catch (Exception e) {
                Console.printerrln((String)("Could not parse " + source + ": " + e.getMessage()));
            }
        }
    }

    public String help() {
        return "parseDirHTTP <directory> [<sequencesName>]";
    }
}

