/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.httpmonitor;

import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorComponent;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorException;
import de.ugoe.cs.util.console.Console;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class HttpMonitorServer
implements HttpMonitorComponent {
    private int port;
    private Server server;
    private Servlet servlet;

    public HttpMonitorServer(int port, Servlet servlet) {
        this.port = port;
        this.servlet = servlet;
    }

    @Override
    public synchronized void init() {
        if (this.server != null) {
            throw new IllegalStateException("already initialized. First call stop()");
        }
        this.server = new Server(this.port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        context.addServlet(new ServletHolder(this.servlet), "/*");
    }

    @Override
    public synchronized void start() throws HttpMonitorException {
        if (this.server == null) {
            throw new IllegalStateException("server not initialized yet. First call init()");
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new HttpMonitorException("could not start server", e);
        }
    }

    @Override
    public synchronized void stop() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            Console.printerrln((String)("could not stop server: " + e.getMessage()));
            Console.logException((Exception)e);
        }
    }
}

