/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.util.console;

import de.ugoe.cs.util.StringTools;
import de.ugoe.cs.util.console.ConsoleObserver;
import de.ugoe.cs.util.console.listener.ICommandListener;
import de.ugoe.cs.util.console.listener.IErrorListener;
import de.ugoe.cs.util.console.listener.IExceptionListener;
import de.ugoe.cs.util.console.listener.IOutputListener;
import de.ugoe.cs.util.console.listener.ITraceListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;

public final class Console {
    private Collection<IOutputListener> outputListener;
    private Collection<IErrorListener> errorListener;
    private Collection<ITraceListener> traceListener;
    private Collection<ICommandListener> commandListener;
    private Collection<IExceptionListener> exceptionListener;
    private static Console theInstance = new Console();

    public static Console getInstance() {
        return theInstance;
    }

    public static void reset() {
        theInstance.init();
    }

    private Console() {
        this.init();
    }

    private void init() {
        this.outputListener = new LinkedHashSet<IOutputListener>();
        this.errorListener = new LinkedHashSet<IErrorListener>();
        this.traceListener = new LinkedHashSet<ITraceListener>();
        this.commandListener = new LinkedHashSet<ICommandListener>();
        this.exceptionListener = new LinkedHashSet<IExceptionListener>();
    }

    public void registerObserver(ConsoleObserver observer) {
        this.registerOutputListener(observer);
        this.registerErrorListener(observer);
        this.registerTraceListener(observer);
        this.registerCommandListener(observer);
        this.registerExceptionListener(observer);
    }

    public void registerOutputListener(IOutputListener listener) {
        this.outputListener.add(listener);
    }

    public void registerErrorListener(IErrorListener listener) {
        this.errorListener.add(listener);
    }

    public void registerTraceListener(ITraceListener listener) {
        this.traceListener.add(listener);
    }

    public void registerCommandListener(ICommandListener listener) {
        this.commandListener.add(listener);
    }

    public void registerExceptionListener(IExceptionListener listener) {
        this.exceptionListener.add(listener);
    }

    public void deleteObserver(ConsoleObserver observer) {
        this.removeOutputListener(observer);
        this.removeErrorListener(observer);
        this.removeTraceListener(observer);
        this.removeCommandListener(observer);
        this.removeExceptionListener(observer);
    }

    public void removeOutputListener(IOutputListener listener) {
        this.outputListener.remove(listener);
    }

    public void removeErrorListener(IErrorListener listener) {
        this.errorListener.remove(listener);
    }

    public void removeTraceListener(ITraceListener listener) {
        this.traceListener.remove(listener);
    }

    public void removeCommandListener(ICommandListener listener) {
        this.commandListener.remove(listener);
    }

    public void removeExceptionListener(IExceptionListener listener) {
        this.exceptionListener.remove(listener);
    }

    public boolean hasOutputListener(IOutputListener listener) {
        return this.outputListener.contains(listener);
    }

    public boolean hasErrorListener(IErrorListener listener) {
        return this.errorListener.contains(listener);
    }

    public boolean hasTraceListener(ITraceListener listener) {
        return this.traceListener.contains(listener);
    }

    public boolean hasCommandListener(ICommandListener listener) {
        return this.commandListener.contains(listener);
    }

    public boolean hasExceptionListener(IExceptionListener listener) {
        return this.exceptionListener.contains(listener);
    }

    public static void print(String msg) {
        for (IOutputListener observer : Console.theInstance.outputListener) {
            observer.outputMsg(msg);
        }
    }

    public static void println(String msg) {
        for (IOutputListener observer : Console.theInstance.outputListener) {
            observer.outputMsg(String.valueOf(msg) + StringTools.ENDLINE);
        }
    }

    public static void printerr(String errMsg) {
        for (IErrorListener observer : Console.theInstance.errorListener) {
            observer.errorMsg(errMsg);
        }
    }

    public static void printerrln(String errMsg) {
        for (IErrorListener observer : Console.theInstance.errorListener) {
            observer.errorMsg(String.valueOf(errMsg) + StringTools.ENDLINE);
        }
    }

    public static void logException(Exception e) {
        for (IExceptionListener observer : Console.theInstance.exceptionListener) {
            observer.logException(e);
        }
    }

    @Deprecated
    public static void trace(String traceMsg) {
        Console.trace(Level.INFO, traceMsg);
    }

    public static void trace(Level logLevel, String traceMsg) {
        for (ITraceListener observer : Console.theInstance.traceListener) {
            observer.traceMsg(traceMsg, logLevel);
        }
    }

    @Deprecated
    public static void traceln(String traceMsg) {
        Console.trace(Level.INFO, String.valueOf(traceMsg) + StringTools.ENDLINE);
    }

    public static void traceln(Level logLevel, String traceMsg) {
        Console.trace(logLevel, String.valueOf(traceMsg) + StringTools.ENDLINE);
    }

    static void commandNotification(String command) {
        for (ICommandListener observer : Console.theInstance.commandListener) {
            observer.commandNotification(command);
        }
    }
}

