//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.tasktrees.treeifc.DefaultTaskInstanceTraversingVisitor;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceVisitor;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class TaskTreeTestRule implements UsabilityEvaluationRule {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.usability.UsabilityEvaluationRule#evaluate(TaskTree)
     */
    @Override
    public UsabilityEvaluationResult evaluate(ITaskModel taskModel) {
        UsabilityEvaluationResult results = new UsabilityEvaluationResult(taskModel);

        checkTimestamps(taskModel);

        return results;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param taskModel
     */
    private void checkTimestamps(ITaskModel taskModel) {
        for (IUserSession session : taskModel.getUserSessions()) {
            ITaskInstanceVisitor visitor = new DefaultTaskInstanceTraversingVisitor() {
                Event lastEvent = null;
                
                @Override
                public void visit(IEventTaskInstance eventTaskInstance) {
                    if (lastEvent != null) {
                        if (eventTaskInstance.getEvent().getTimestamp() < lastEvent.getTimestamp()) {
                            System.out.println("timestamp problem encountered:");
                            System.out.println("  " + lastEvent.getTimestamp() + "  " + lastEvent);
                            System.out.println("  " + eventTaskInstance.getEvent().getTimestamp() + "  " + eventTaskInstance.getEvent());
                        }
                    }
                    
                    lastEvent = eventTaskInstance.getEvent();
                }
                
            };
            
            for (ITaskInstance instance : session) {
                visitor.visit(instance);
            }
        }
        
    }
}
