/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.eventcore;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.eventcore.IReplayable;
import de.ugoe.cs.autoquest.eventcore.StringEventType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Event STARTEVENT = new Event(new StringEventType("START"));
    public static final Event ENDEVENT = new Event(new StringEventType("END"));
    private IEventType type;
    private IEventTarget target = null;
    private long timestamp = Long.MIN_VALUE;
    private Map<String, String> parameters = new HashMap<String, String>();
    private List<IReplayable> replay = new LinkedList<IReplayable>();

    public Event(IEventType type) {
        if (type == null) {
            throw new IllegalArgumentException("Event type must not be null");
        }
        this.type = type;
    }

    public Event(IEventType type, IEventTarget target) {
        this(type);
        this.target = target;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Event) {
            Event otherEvent = (Event)other;
            if (this.target != null) {
                return this.type.equals(otherEvent.type) && this.target.equals(otherEvent.target);
            }
            return this.type.equals(otherEvent.type) && otherEvent.target == null;
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    public IEventTarget getTarget() {
        return this.target;
    }

    public IEventType getType() {
        return this.type;
    }

    public String getId() {
        String id = this.type.toString();
        if (this.target != null) {
            id = String.valueOf(id) + "." + this.target.getStringIdentifier();
        }
        return id;
    }

    public int hashCode() {
        int multiplier = 17;
        int hash = 42;
        if (this.type != null) {
            hash = multiplier * hash + this.type.hashCode();
        }
        if (this.target != null) {
            hash = multiplier * hash + this.target.hashCode();
        }
        return hash;
    }

    public boolean setTarget(IEventTarget target) {
        if (this.target != null) {
            return false;
        }
        this.target = target;
        return true;
    }

    public void addReplayable(IReplayable replayable) {
        if (replayable == null) {
            throw new IllegalArgumentException("replayble must not be null");
        }
        this.replay.add(replayable);
    }

    public void addReplayableSequence(List<? extends IReplayable> generatedReplaySeq) {
        if (generatedReplaySeq == null) {
            throw new IllegalArgumentException("generatedReplaySeq must not be null");
        }
        this.replay.addAll(generatedReplaySeq);
    }

    public void setParameter(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            this.parameters.remove(key);
        } else {
            this.parameters.put(key, value);
        }
    }

    public String getParameter(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        return this.parameters.get(key);
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<IReplayable> getReplayables() {
        return new LinkedList<IReplayable>(this.replay);
    }
}

