/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public abstract class AbstractHttpClientTransport
extends ContainerLifeCycle
implements HttpClientTransport {
    protected static final Logger LOG = Log.getLogger(HttpClientTransport.class);
    private final int selectors;
    private volatile HttpClient client;
    private volatile SelectorManager selectorManager;

    protected AbstractHttpClientTransport(int selectors) {
        this.selectors = selectors;
    }

    protected HttpClient getHttpClient() {
        return this.client;
    }

    @Override
    public void setHttpClient(HttpClient client) {
        this.client = client;
    }

    protected void doStart() throws Exception {
        this.selectorManager = this.newSelectorManager(this.client);
        this.selectorManager.setConnectTimeout(this.client.getConnectTimeout());
        this.addBean(this.selectorManager);
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(HttpDestination destination, SocketAddress address, Promise<Connection> promise) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            HttpClient client = destination.getHttpClient();
            SocketAddress bindAddress = client.getBindAddress();
            if (bindAddress != null) {
                channel.bind(bindAddress);
            }
            this.configure(client, channel);
            channel.configureBlocking(false);
            channel.connect(address);
            ConnectionCallback callback = new ConnectionCallback(destination, promise);
            this.selectorManager.connect(channel, (Object)callback);
        }
        catch (Throwable x) {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException xx) {
                LOG.ignore((Throwable)xx);
            }
            finally {
                promise.failed(x);
            }
        }
    }

    protected void configure(HttpClient client, SocketChannel channel) throws SocketException {
        channel.socket().setTcpNoDelay(client.isTCPNoDelay());
    }

    protected SelectorManager newSelectorManager(HttpClient client) {
        return new ClientSelectorManager(client, this.selectors);
    }

    protected SslConnection createSslConnection(EndPoint endPoint, HttpDestination destination) {
        HttpClient httpClient = destination.getHttpClient();
        SslContextFactory sslContextFactory = httpClient.getSslContextFactory();
        SSLEngine engine = sslContextFactory.newSSLEngine(destination.getHost(), destination.getPort());
        engine.setUseClientMode(true);
        SslConnection sslConnection = this.newSslConnection(httpClient, endPoint, engine);
        sslConnection.setRenegotiationAllowed(sslContextFactory.isRenegotiationAllowed());
        endPoint.setConnection((org.eclipse.jetty.io.Connection)sslConnection);
        SslConnection.DecryptedEndPoint appEndPoint = sslConnection.getDecryptedEndPoint();
        org.eclipse.jetty.io.Connection connection = this.newConnection((EndPoint)appEndPoint, destination);
        appEndPoint.setConnection(connection);
        return sslConnection;
    }

    protected SslConnection newSslConnection(HttpClient httpClient, EndPoint endPoint, SSLEngine engine) {
        return new SslConnection(httpClient.getByteBufferPool(), httpClient.getExecutor(), endPoint, engine);
    }

    protected abstract org.eclipse.jetty.io.Connection newConnection(EndPoint var1, HttpDestination var2);

    protected Connection tunnel(EndPoint endPoint, HttpDestination destination, Connection connection) {
        SslConnection sslConnection = this.createSslConnection(endPoint, destination);
        org.eclipse.jetty.io.Connection result = sslConnection.getDecryptedEndPoint().getConnection();
        this.selectorManager.connectionClosed((org.eclipse.jetty.io.Connection)connection);
        this.selectorManager.connectionOpened((org.eclipse.jetty.io.Connection)sslConnection);
        LOG.debug("Tunnelled {} over {}", new Object[]{connection, result});
        return (Connection)result;
    }

    private class ConnectionCallback
    implements Promise<Connection> {
        private final HttpDestination destination;
        private final Promise<Connection> promise;

        private ConnectionCallback(HttpDestination destination, Promise<Connection> promise) {
            this.destination = destination;
            this.promise = promise;
        }

        public void succeeded(Connection result) {
            this.promise.succeeded((Object)result);
        }

        public void failed(Throwable x) {
            this.promise.failed(x);
        }
    }

    protected class ClientSelectorManager
    extends SelectorManager {
        private final HttpClient client;

        protected ClientSelectorManager(HttpClient client, int selectors) {
            super(client.getExecutor(), client.getScheduler(), selectors);
            this.client = client;
        }

        protected EndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selector, SelectionKey key) {
            return new SelectChannelEndPoint(channel, selector, key, this.getScheduler(), this.client.getIdleTimeout());
        }

        public org.eclipse.jetty.io.Connection newConnection(SocketChannel channel, EndPoint endPoint, Object attachment) throws IOException {
            ConnectionCallback callback = (ConnectionCallback)attachment;
            HttpDestination destination = callback.destination;
            SslContextFactory sslContextFactory = this.client.getSslContextFactory();
            if (!destination.isProxied() && HttpScheme.HTTPS.is(destination.getScheme())) {
                if (sslContextFactory == null) {
                    ConnectException failure = new ConnectException("Missing " + SslContextFactory.class.getSimpleName() + " for " + destination.getScheme() + " requests");
                    callback.failed(failure);
                    throw failure;
                }
                SslConnection sslConnection = AbstractHttpClientTransport.this.createSslConnection(endPoint, destination);
                callback.succeeded((Connection)sslConnection.getDecryptedEndPoint().getConnection());
                return sslConnection;
            }
            org.eclipse.jetty.io.Connection connection = AbstractHttpClientTransport.this.newConnection(endPoint, destination);
            callback.succeeded((Connection)connection);
            return connection;
        }

        protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
            ConnectionCallback callback = (ConnectionCallback)attachment;
            callback.failed(ex);
        }
    }
}

