/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.plugin.http.eventcore;

import de.ugoe.cs.autoquest.httpmonitor.exchange.Header;
import de.ugoe.cs.autoquest.httpmonitor.exchange.HttpExchange;
import de.ugoe.cs.autoquest.plugin.http.HTTPUtils;
import de.ugoe.cs.autoquest.plugin.http.eventcore.HTTPEventType;
import de.ugoe.cs.util.console.Console;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SOAPEventType
extends HTTPEventType {
    private static final long serialVersionUID = 1L;
    private SOAPMessage soapRequest;
    private SOAPMessage soapResponse;
    private String calledMethod;
    private String name;

    public SOAPEventType(HttpExchange exchange, SOAPMessage soapRequest, SOAPMessage soapResponse) {
        super(exchange);
        this.soapRequest = soapRequest;
        this.soapResponse = soapResponse;
        this.calledMethod = this.determineCalledMethod(exchange, soapRequest);
        String path = null;
        if (exchange.getRequest() != null && exchange.getRequest().getUrl() != null) {
            try {
                path = new URL(exchange.getRequest().getUrl()).getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        StringBuffer nameBuffer = new StringBuffer("SOAPEvent");
        boolean somethingAdded = false;
        if (path != null) {
            nameBuffer.append("(");
            nameBuffer.append(path);
            somethingAdded = true;
        }
        if (this.calledMethod != null) {
            nameBuffer.append(somethingAdded ? ", " : "(");
            nameBuffer.append(this.calledMethod);
            somethingAdded = true;
        }
        String senderStr = HTTPUtils.toString(exchange.getSender());
        String receiverStr = HTTPUtils.toString(exchange.getReceiver());
        if (senderStr != null && receiverStr != null) {
            nameBuffer.append(somethingAdded ? ", " : "(");
            nameBuffer.append(senderStr);
            nameBuffer.append(" --> ");
            nameBuffer.append(receiverStr);
            somethingAdded = true;
        } else if (senderStr != null) {
            nameBuffer.append(somethingAdded ? ", " : "(");
            nameBuffer.append(senderStr);
            somethingAdded = true;
        } else if (receiverStr != null) {
            nameBuffer.append(somethingAdded ? ", " : "(");
            nameBuffer.append(receiverStr);
            somethingAdded = true;
        }
        if (somethingAdded) {
            nameBuffer.append(")");
        }
        this.name = nameBuffer.toString();
    }

    public String getCalledMethod() {
        return this.calledMethod;
    }

    public SOAPMessage getSoapRequest() {
        return this.soapRequest;
    }

    public SOAPMessage getSoapResponse() {
        return this.soapResponse;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SOAPEventType) {
            return super.equals(obj) && HTTPUtils.equals(this.calledMethod, ((SOAPEventType)obj).calledMethod);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.calledMethod.hashCode();
    }

    private String determineCalledMethod(HttpExchange exchange, SOAPMessage soapRequest) {
        if (exchange.getRequest() != null && exchange.getRequest().getHeaders() != null && exchange.getRequest().getHeaders().getHeader() != null) {
            for (Header header : exchange.getRequest().getHeaders().getHeader()) {
                if (!"SOAPAction".equalsIgnoreCase(header.getKey())) continue;
                return header.getValue();
            }
        }
        try {
            if (soapRequest.getSOAPBody() != null && soapRequest.getSOAPBody().getChildNodes() != null && soapRequest.getSOAPBody().getChildNodes().getLength() > 0) {
                return soapRequest.getSOAPBody().getChildNodes().item(0).getNodeName();
            }
        }
        catch (SOAPException e) {
            Console.traceln((Level)Level.WARNING, (String)("could not process SOAP message correctly: " + (Object)((Object)e)));
            Console.logException((Exception)((Object)e));
        }
        return null;
    }
}

