/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.keyboardmaps;

import de.ugoe.cs.autoquest.keyboardmaps.KeyStroke;
import de.ugoe.cs.autoquest.keyboardmaps.VirtualKey;
import de.ugoe.cs.autoquest.keyboardmaps.VirtualKeySynonyms;
import de.ugoe.cs.util.console.Console;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public class KeyboardMap {
    private Locale locale;
    private String fileName;
    private Map<VirtualKey, List<KeyStroke>> keyStrokes = new HashMap<VirtualKey, List<KeyStroke>>();

    KeyboardMap(Locale locale) {
        this.locale = locale;
        this.fileName = this.locale == Locale.ENGLISH || this.locale == Locale.US || this.locale == Locale.CANADA ? "en-us" : (locale == Locale.UK ? "en-gb" : locale.getLanguage());
    }

    public char getCharacterFor(VirtualKey key, boolean numlock, boolean shift, boolean altgr, boolean inhibit) {
        List<KeyStroke> candidates = this.keyStrokes.get((Object)key);
        if (candidates == null) {
            return '\u0000';
        }
        for (KeyStroke keyStroke : candidates) {
            if (numlock != keyStroke.getNumlock() || keyStroke.getLocalstate() || shift != keyStroke.getShift() || altgr != keyStroke.getAltgr() || inhibit != keyStroke.getInhibit()) continue;
            return keyStroke.getCharacter();
        }
        for (KeyStroke keyStroke : candidates) {
            if (numlock != keyStroke.getNumlock() || !keyStroke.getLocalstate() || inhibit != keyStroke.getInhibit()) continue;
            return keyStroke.getCharacter();
        }
        return '\u0000';
    }

    void init() throws IllegalArgumentException {
        Console.traceln((Level)Level.FINE, (String)("initializing keymap for locale " + this.locale));
        ArrayList<String[]> deadKeySequences = new ArrayList<String[]>();
        ArrayList<String[]> keyStrokes = new ArrayList<String[]>();
        this.readStream(this.getStream(this.fileName), deadKeySequences, keyStrokes);
        Console.traceln((Level)Level.FINER, (String)("read " + keyStrokes.size() + " key strokes and " + deadKeySequences.size() + " dead key sequences"));
        VirtualKeySynonyms virtualKeySynonyms = this.determineVirtualKeySynonyms(keyStrokes);
        this.processKeyStrokes(keyStrokes, virtualKeySynonyms);
    }

    private InputStream getStream(String name) {
        Console.traceln((Level)Level.FINER, (String)("reading keymap for locale " + this.locale + " from resource keymaps/" + name));
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("keymaps/" + name);
        if (stream == null) {
            throw new IllegalArgumentException("no keyboard map available for locale " + this.locale);
        }
        return stream;
    }

    /*
     * Exception decompiling
     */
    private void readStream(InputStream stream, List<String[]> deadKeySequences, List<String[]> keyStrokes) throws IllegalArgumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processLine(String line, List<String[]> deadKeySequences, List<String[]> keyStrokes) {
        String[] values = line.split(" ");
        if (values.length <= 0) {
            return;
        }
        if (values[0].startsWith("#")) {
            return;
        }
        if (!"map".equals(values[0])) {
            if ("include".equals(values[0])) {
                int i = 1;
                while (i < values.length) {
                    if (!values[i].startsWith("#")) {
                        this.readStream(this.getStream(values[i]), deadKeySequences, keyStrokes);
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if ("sequence".equals(values[0])) {
                deadKeySequences.add(values);
            } else {
                boolean alreadyAdded = false;
                int i = 0;
                while (i < keyStrokes.size()) {
                    if (keyStrokes.get(i)[0].equals(values[0])) {
                        Console.traceln((Level)Level.FINEST, (String)("replacing key stroke " + values[0] + " with former keyid " + keyStrokes.get(i)[1] + " with new key id " + values[1]));
                        keyStrokes.set(i, values);
                        alreadyAdded = true;
                        break;
                    }
                    ++i;
                }
                if (!alreadyAdded) {
                    keyStrokes.add(values);
                }
            }
        }
    }

    private VirtualKeySynonyms determineVirtualKeySynonyms(List<String[]> keyStrokes) {
        Console.traceln((Level)Level.FINER, (String)"determining virtual keys and synonyms for the keymap");
        VirtualKeySynonyms virtualKeySynonyms = new VirtualKeySynonyms();
        ArrayList<String[]> unmatchedKeyStrokes = new ArrayList<String[]>();
        for (String[] keyStroke : keyStrokes) {
            String keyStrokeName = keyStroke[0];
            int keyId = this.getKeyId(keyStroke[1]);
            VirtualKey virtualKey = this.determineVirtualKey(keyStrokeName);
            if (virtualKey != null) {
                virtualKeySynonyms.add(keyId, virtualKey);
                continue;
            }
            unmatchedKeyStrokes.add(keyStroke);
        }
        for (String[] unmatchedKeyStroke : unmatchedKeyStrokes) {
            if (virtualKeySynonyms.containsKey(this.getKeyId(unmatchedKeyStroke[1]))) continue;
            Console.traceln((Level)Level.FINEST, (String)("no virtual key mapped to key stroke " + unmatchedKeyStroke[0] + "(" + unmatchedKeyStroke[1] + ") of keyboard map for locale " + this.locale));
        }
        return virtualKeySynonyms;
    }

    private int getKeyId(String keyIdString) {
        if (keyIdString.startsWith("0x")) {
            keyIdString = keyIdString.substring(2);
        }
        return Integer.parseInt(keyIdString, 16);
    }

    private void processKeyStrokes(List<String[]> keyStrokes, VirtualKeySynonyms virtualKeySynonyms) {
        for (String[] keyStroke : keyStrokes) {
            this.handleKeyStroke(keyStroke, virtualKeySynonyms);
        }
        this.addKeyStrokesIndependentOfNumLock();
    }

    private void handleKeyStroke(String[] values, VirtualKeySynonyms virtualKeySynonyms) {
        String keyStrokeName = values[0];
        String keyIdString = values[1];
        if (keyIdString.startsWith("0x")) {
            keyIdString = keyIdString.substring(2);
        }
        int keyId = Integer.parseInt(keyIdString, 16);
        boolean numlock = false;
        boolean localstate = false;
        boolean shift = false;
        boolean altgr = false;
        boolean addupper = false;
        boolean inhibit = false;
        int i = 2;
        while (i < values.length) {
            if (values[i].startsWith("#")) break;
            if ("numlock".equals(values[i])) {
                numlock = true;
            } else if ("localstate".equals(values[i])) {
                localstate = true;
            } else if ("shift".equals(values[i])) {
                shift = true;
            } else if ("altgr".equals(values[i])) {
                altgr = true;
            } else if ("addupper".equals(values[i])) {
                addupper = true;
            } else if ("inhibit".equals(values[i])) {
                inhibit = true;
            } else {
                Console.traceln((Level)Level.SEVERE, (String)("unknown condition " + values[i] + " specified for key stroke " + keyStrokeName + " through keyboard map for locale " + this.locale));
                throw new IllegalArgumentException("no keyboard map available for locale " + this.locale);
            }
            ++i;
        }
        this.addAllRepresentedKeyStrokes(keyStrokeName, keyId, numlock, localstate, shift, altgr, addupper, inhibit, virtualKeySynonyms);
    }

    private void addAllRepresentedKeyStrokes(String keyStrokeName, int keyId, boolean numlock, boolean localstate, boolean shift, boolean altgr, boolean addupper, boolean inhibit, VirtualKeySynonyms virtualKeySynonyms) {
        VirtualKey[] virtualKeys = virtualKeySynonyms.getVirtualKeySynonyms(keyId);
        if (virtualKeys == null) {
            Console.traceln((Level)Level.SEVERE, (String)("no virtual key mapped to key stroke " + keyStrokeName + " of keyboard map for locale " + this.locale));
            return;
        }
        VirtualKey[] virtualKeyArray = virtualKeys;
        int n = virtualKeys.length;
        int n2 = 0;
        while (n2 < n) {
            char c;
            VirtualKey virtualKey = virtualKeyArray[n2];
            if (addupper) {
                c = this.determineCharacter(keyStrokeName, true);
                this.addKeyStroke(keyStrokeName, virtualKey, numlock, localstate, true, altgr, inhibit, c);
                c = this.determineCharacter(keyStrokeName, false);
                this.addKeyStroke(keyStrokeName, virtualKey, numlock, localstate, false, altgr, inhibit, c);
            } else {
                c = this.determineCharacter(keyStrokeName, false);
                this.addKeyStroke(keyStrokeName, virtualKey, numlock, localstate, shift, altgr, inhibit, c);
            }
            ++n2;
        }
    }

    private void addKeyStroke(String keyStrokeName, VirtualKey virtualKey, boolean numlock, boolean localstate, boolean shift, boolean altgr, boolean inhibit, char character) {
        KeyStroke keyStroke = new KeyStroke(keyStrokeName, virtualKey, numlock, localstate, shift, altgr, inhibit, character);
        List<KeyStroke> keyStrokeList = this.keyStrokes.get((Object)keyStroke.getVirtualKey());
        if (keyStrokeList == null) {
            keyStrokeList = new ArrayList<KeyStroke>();
            this.keyStrokes.put(keyStroke.getVirtualKey(), keyStrokeList);
        }
        keyStrokeList.add(keyStroke);
    }

    private void addKeyStrokesIndependentOfNumLock() {
        for (Map.Entry<VirtualKey, List<KeyStroke>> entry : this.keyStrokes.entrySet()) {
            ArrayList<KeyStroke> keyStrokesToAdd = new ArrayList<KeyStroke>();
            for (KeyStroke keyStroke : entry.getValue()) {
                if (keyStroke.getNumlock()) continue;
                boolean foundPositiveNumlockVariant = false;
                for (KeyStroke candidate : entry.getValue()) {
                    if (candidate.getShift() != keyStroke.getShift() || candidate.getAltgr() != keyStroke.getAltgr() || candidate.getLocalstate() != keyStroke.getLocalstate() || candidate.getInhibit() != keyStroke.getInhibit() || !candidate.getNumlock()) continue;
                    foundPositiveNumlockVariant = true;
                    break;
                }
                if (foundPositiveNumlockVariant) continue;
                keyStrokesToAdd.add(keyStroke);
            }
            for (KeyStroke keyStroke : keyStrokesToAdd) {
                this.addKeyStroke(keyStroke.getKeyStrokeName(), keyStroke.getVirtualKey(), true, keyStroke.getLocalstate(), keyStroke.getShift(), keyStroke.getAltgr(), keyStroke.getInhibit(), keyStroke.getCharacter());
            }
        }
    }

    private VirtualKey determineVirtualKey(String keyStrokeName) {
        if ("Shift_R".equals(keyStrokeName)) {
            return VirtualKey.SHIFT;
        }
        if ("Shift_L".equals(keyStrokeName)) {
            return VirtualKey.SHIFT;
        }
        if ("Alt_R".equals(keyStrokeName)) {
            return VirtualKey.ALT_GRAPH;
        }
        if ("Mode_switch".equals(keyStrokeName)) {
            return VirtualKey.MODECHANGE;
        }
        if ("ISO_Level3_Shift".equals(keyStrokeName)) {
            return VirtualKey.SHIFT;
        }
        if ("Alt_L".equals(keyStrokeName)) {
            return VirtualKey.ALT;
        }
        if ("Control_R".equals(keyStrokeName)) {
            return VirtualKey.CONTROL;
        }
        if ("Control_L".equals(keyStrokeName)) {
            return VirtualKey.CONTROL;
        }
        if ("Menu".equals(keyStrokeName)) {
            return VirtualKey.WINDOWS;
        }
        if ("1".equals(keyStrokeName)) {
            return VirtualKey.DIGIT_1;
        }
        if ("2".equals(keyStrokeName)) {
            return VirtualKey.DIGIT_2;
        }
        if ("3".equals(keyStrokeName)) {
            return VirtualKey.DIGIT_3;
        }
        if ("4".equals(keyStrokeName)) {
            return VirtualKey.DIGIT_4;
        }
        if ("5".equals(keyStrokeName)) {
            return VirtualKey.DIGIT_5;
        }
        if ("6".equals(keyStrokeName)) {
            return VirtualKey.DIGIT_6;
        }
        if ("7".equals(keyStrokeName)) {
            return VirtualKey.DIGIT_7;
        }
        if ("8".equals(keyStrokeName)) {
            return VirtualKey.DIGIT_8;
        }
        if ("9".equals(keyStrokeName)) {
            return VirtualKey.DIGIT_9;
        }
        if ("0".equals(keyStrokeName)) {
            return VirtualKey.DIGIT_0;
        }
        if ("BackSpace".equals(keyStrokeName)) {
            return VirtualKey.BACK_SPACE;
        }
        if ("Tab".equals(keyStrokeName)) {
            return VirtualKey.TAB;
        }
        if ("q".equals(keyStrokeName)) {
            return VirtualKey.LETTER_Q;
        }
        if ("w".equals(keyStrokeName)) {
            return VirtualKey.LETTER_W;
        }
        if ("e".equals(keyStrokeName)) {
            return VirtualKey.LETTER_E;
        }
        if ("r".equals(keyStrokeName)) {
            return VirtualKey.LETTER_R;
        }
        if ("t".equals(keyStrokeName)) {
            return VirtualKey.LETTER_T;
        }
        if ("y".equals(keyStrokeName)) {
            return VirtualKey.LETTER_Y;
        }
        if ("u".equals(keyStrokeName)) {
            return VirtualKey.LETTER_U;
        }
        if ("i".equals(keyStrokeName)) {
            return VirtualKey.LETTER_I;
        }
        if ("o".equals(keyStrokeName)) {
            return VirtualKey.LETTER_O;
        }
        if ("p".equals(keyStrokeName)) {
            return VirtualKey.LETTER_P;
        }
        if ("a".equals(keyStrokeName)) {
            return VirtualKey.LETTER_A;
        }
        if ("s".equals(keyStrokeName)) {
            return VirtualKey.LETTER_S;
        }
        if ("d".equals(keyStrokeName)) {
            return VirtualKey.LETTER_D;
        }
        if ("f".equals(keyStrokeName)) {
            return VirtualKey.LETTER_F;
        }
        if ("g".equals(keyStrokeName)) {
            return VirtualKey.LETTER_G;
        }
        if ("h".equals(keyStrokeName)) {
            return VirtualKey.LETTER_H;
        }
        if ("j".equals(keyStrokeName)) {
            return VirtualKey.LETTER_J;
        }
        if ("k".equals(keyStrokeName)) {
            return VirtualKey.LETTER_K;
        }
        if ("l".equals(keyStrokeName)) {
            return VirtualKey.LETTER_L;
        }
        if ("Return".equals(keyStrokeName)) {
            return VirtualKey.ENTER;
        }
        if ("z".equals(keyStrokeName)) {
            return VirtualKey.LETTER_Z;
        }
        if ("x".equals(keyStrokeName)) {
            return VirtualKey.LETTER_X;
        }
        if ("c".equals(keyStrokeName)) {
            return VirtualKey.LETTER_C;
        }
        if ("v".equals(keyStrokeName)) {
            return VirtualKey.LETTER_V;
        }
        if ("b".equals(keyStrokeName)) {
            return VirtualKey.LETTER_B;
        }
        if ("n".equals(keyStrokeName)) {
            return VirtualKey.LETTER_N;
        }
        if ("m".equals(keyStrokeName)) {
            return VirtualKey.LETTER_M;
        }
        if ("space".equals(keyStrokeName)) {
            return VirtualKey.SPACE;
        }
        if ("less".equals(keyStrokeName)) {
            return VirtualKey.LESS;
        }
        if ("greater".equals(keyStrokeName)) {
            return VirtualKey.GREATER;
        }
        if ("Escape".equals(keyStrokeName)) {
            return VirtualKey.ESCAPE;
        }
        if ("F1".equals(keyStrokeName)) {
            return VirtualKey.F1;
        }
        if ("F2".equals(keyStrokeName)) {
            return VirtualKey.F2;
        }
        if ("F3".equals(keyStrokeName)) {
            return VirtualKey.F3;
        }
        if ("F4".equals(keyStrokeName)) {
            return VirtualKey.F4;
        }
        if ("F5".equals(keyStrokeName)) {
            return VirtualKey.F5;
        }
        if ("F6".equals(keyStrokeName)) {
            return VirtualKey.F6;
        }
        if ("F7".equals(keyStrokeName)) {
            return VirtualKey.F7;
        }
        if ("F8".equals(keyStrokeName)) {
            return VirtualKey.F8;
        }
        if ("F9".equals(keyStrokeName)) {
            return VirtualKey.F9;
        }
        if ("F10".equals(keyStrokeName)) {
            return VirtualKey.F10;
        }
        if ("F11".equals(keyStrokeName)) {
            return VirtualKey.F11;
        }
        if ("F12".equals(keyStrokeName)) {
            return VirtualKey.F12;
        }
        if ("F13".equals(keyStrokeName)) {
            return VirtualKey.F13;
        }
        if ("F14".equals(keyStrokeName)) {
            return VirtualKey.F14;
        }
        if ("F15".equals(keyStrokeName)) {
            return VirtualKey.F15;
        }
        if ("F16".equals(keyStrokeName)) {
            return VirtualKey.F16;
        }
        if ("F17".equals(keyStrokeName)) {
            return VirtualKey.F17;
        }
        if ("F18".equals(keyStrokeName)) {
            return VirtualKey.F18;
        }
        if ("F19".equals(keyStrokeName)) {
            return VirtualKey.F19;
        }
        if ("F20".equals(keyStrokeName)) {
            return VirtualKey.F20;
        }
        if ("F21".equals(keyStrokeName)) {
            return VirtualKey.F21;
        }
        if ("F22".equals(keyStrokeName)) {
            return VirtualKey.F22;
        }
        if ("F23".equals(keyStrokeName)) {
            return VirtualKey.F23;
        }
        if ("F24".equals(keyStrokeName)) {
            return VirtualKey.F24;
        }
        if ("Print".equals(keyStrokeName)) {
            return VirtualKey.PRINTSCREEN;
        }
        if ("Scroll_Lock".equals(keyStrokeName)) {
            return VirtualKey.SCROLL_LOCK;
        }
        if ("Insert".equals(keyStrokeName)) {
            return VirtualKey.INSERT;
        }
        if ("Delete".equals(keyStrokeName)) {
            return VirtualKey.DELETE;
        }
        if ("Home".equals(keyStrokeName)) {
            return VirtualKey.HOME;
        }
        if ("End".equals(keyStrokeName)) {
            return VirtualKey.END;
        }
        if ("Page_Up".equals(keyStrokeName)) {
            return VirtualKey.PAGE_UP;
        }
        if ("Page_Down".equals(keyStrokeName)) {
            return VirtualKey.PAGE_DOWN;
        }
        if ("Left".equals(keyStrokeName)) {
            return VirtualKey.LEFT;
        }
        if ("Up".equals(keyStrokeName)) {
            return VirtualKey.UP;
        }
        if ("Down".equals(keyStrokeName)) {
            return VirtualKey.DOWN;
        }
        if ("Right".equals(keyStrokeName)) {
            return VirtualKey.RIGHT;
        }
        if ("Num_Lock".equals(keyStrokeName)) {
            return VirtualKey.NUM_LOCK;
        }
        if ("KP_Divide".equals(keyStrokeName)) {
            return VirtualKey.SLASH;
        }
        if ("KP_Multiply".equals(keyStrokeName)) {
            return VirtualKey.ASTERISK;
        }
        if ("KP_Subtract".equals(keyStrokeName)) {
            return VirtualKey.MINUS;
        }
        if ("KP_Add".equals(keyStrokeName)) {
            return VirtualKey.PLUS;
        }
        if ("KP_Enter".equals(keyStrokeName)) {
            return VirtualKey.ENTER;
        }
        if ("KP_Decimal".equals(keyStrokeName)) {
            return VirtualKey.DECIMAL;
        }
        if ("KP_Separator".equals(keyStrokeName)) {
            return VirtualKey.SEPARATOR;
        }
        if ("KP_Delete".equals(keyStrokeName)) {
            return VirtualKey.DELETE;
        }
        if ("KP_0".equals(keyStrokeName)) {
            return VirtualKey.NUMPAD_0;
        }
        if ("KP_Insert".equals(keyStrokeName)) {
            return VirtualKey.INSERT;
        }
        if ("KP_1".equals(keyStrokeName)) {
            return VirtualKey.NUMPAD_1;
        }
        if ("KP_End".equals(keyStrokeName)) {
            return VirtualKey.END;
        }
        if ("KP_2".equals(keyStrokeName)) {
            return VirtualKey.NUMPAD_2;
        }
        if ("KP_Down".equals(keyStrokeName)) {
            return VirtualKey.KP_DOWN;
        }
        if ("KP_3".equals(keyStrokeName)) {
            return VirtualKey.NUMPAD_3;
        }
        if ("KP_Next".equals(keyStrokeName)) {
            return VirtualKey.PAGE_DOWN;
        }
        if ("KP_4".equals(keyStrokeName)) {
            return VirtualKey.NUMPAD_4;
        }
        if ("KP_Left".equals(keyStrokeName)) {
            return VirtualKey.KP_LEFT;
        }
        if ("KP_5".equals(keyStrokeName)) {
            return VirtualKey.NUMPAD_5;
        }
        if ("KP_Begin".equals(keyStrokeName)) {
            return VirtualKey.BEGIN;
        }
        if ("KP_6".equals(keyStrokeName)) {
            return VirtualKey.NUMPAD_6;
        }
        if ("KP_Right".equals(keyStrokeName)) {
            return VirtualKey.KP_RIGHT;
        }
        if ("KP_7".equals(keyStrokeName)) {
            return VirtualKey.NUMPAD_7;
        }
        if ("KP_Home".equals(keyStrokeName)) {
            return VirtualKey.HOME;
        }
        if ("KP_8".equals(keyStrokeName)) {
            return VirtualKey.NUMPAD_8;
        }
        if ("KP_Up".equals(keyStrokeName)) {
            return VirtualKey.KP_UP;
        }
        if ("KP_9".equals(keyStrokeName)) {
            return VirtualKey.NUMPAD_9;
        }
        if ("KP_Prior".equals(keyStrokeName)) {
            return VirtualKey.PAGE_UP;
        }
        if ("Caps_Lock".equals(keyStrokeName)) {
            return VirtualKey.CAPS_LOCK;
        }
        if ("exclam".equals(keyStrokeName)) {
            return VirtualKey.EXCLAMATION_MARK;
        }
        if ("exclamdown".equals(keyStrokeName)) {
            return VirtualKey.INVERTED_EXCLAMATION_MARK;
        }
        if ("quotedbl".equals(keyStrokeName)) {
            return VirtualKey.QUOTEDBL;
        }
        if ("slash".equals(keyStrokeName)) {
            return VirtualKey.SLASH;
        }
        if ("backslash".equals(keyStrokeName)) {
            return VirtualKey.BACK_SLASH;
        }
        if ("dead_acute".equals(keyStrokeName)) {
            return VirtualKey.DEAD_ACUTE;
        }
        if ("dead_diaresis".equals(keyStrokeName)) {
            return VirtualKey.DEAD_DIAERESIS;
        }
        if ("dead_abovering".equals(keyStrokeName)) {
            return VirtualKey.DEAD_ABOVERING;
        }
        if ("plus".equals(keyStrokeName)) {
            return VirtualKey.PLUS;
        }
        if ("asterisk".equals(keyStrokeName)) {
            return VirtualKey.ASTERISK;
        }
        if ("dead_tilde".equals(keyStrokeName)) {
            return VirtualKey.DEAD_TILDE;
        }
        if ("dead_doubleacute".equals(keyStrokeName)) {
            return VirtualKey.DEAD_DOUBLEACUTE;
        }
        if ("dead_caron".equals(keyStrokeName)) {
            return VirtualKey.DEAD_CARON;
        }
        if ("dead_circumflex".equals(keyStrokeName)) {
            return VirtualKey.DEAD_CIRCUMFLEX;
        }
        if ("comma".equals(keyStrokeName)) {
            return VirtualKey.COMMA;
        }
        if ("semicolon".equals(keyStrokeName)) {
            return VirtualKey.SEMICOLON;
        }
        if ("multiply".equals(keyStrokeName)) {
            return VirtualKey.MULTIPLY;
        }
        if ("period".equals(keyStrokeName)) {
            return VirtualKey.PERIOD;
        }
        if ("colon".equals(keyStrokeName)) {
            return VirtualKey.COLON;
        }
        if ("dead_breve".equals(keyStrokeName)) {
            return VirtualKey.DEAD_BREVE;
        }
        if ("division".equals(keyStrokeName)) {
            return VirtualKey.DIVIDE;
        }
        if ("minus".equals(keyStrokeName)) {
            return VirtualKey.MINUS;
        }
        if ("underscore".equals(keyStrokeName)) {
            return VirtualKey.UNDERSCORE;
        }
        if ("dead_abovedot".equals(keyStrokeName)) {
            return VirtualKey.DEAD_ABOVEDOT;
        }
        if ("bracketleft".equals(keyStrokeName)) {
            return VirtualKey.OPEN_BRACKET;
        }
        if ("bracketright".equals(keyStrokeName)) {
            return VirtualKey.CLOSE_BRACKET;
        }
        if ("grave".equals(keyStrokeName)) {
            return VirtualKey.DEAD_GRAVE;
        }
        if ("equal".equals(keyStrokeName)) {
            return VirtualKey.EQUALS;
        }
        if ("dead_macron".equals(keyStrokeName)) {
            return VirtualKey.DEAD_MACRON;
        }
        if ("dead_ogonek".equals(keyStrokeName)) {
            return VirtualKey.DEAD_OGONEK;
        }
        if ("dead_cedilla".equals(keyStrokeName)) {
            return VirtualKey.DEAD_CEDILLA;
        }
        if ("ampersand".equals(keyStrokeName)) {
            return VirtualKey.AMPERSAND;
        }
        if ("parenleft".equals(keyStrokeName)) {
            return VirtualKey.LEFT_PARENTHESIS;
        }
        if ("parenright".equals(keyStrokeName)) {
            return VirtualKey.RIGHT_PARENTHESIS;
        }
        if ("braceleft".equals(keyStrokeName)) {
            return VirtualKey.BRACELEFT;
        }
        if ("braceright".equals(keyStrokeName)) {
            return VirtualKey.BRACERIGHT;
        }
        if ("at".equals(keyStrokeName)) {
            return VirtualKey.AT;
        }
        if ("dollar".equals(keyStrokeName)) {
            return VirtualKey.DOLLAR;
        }
        if ("EuroSign".equals(keyStrokeName)) {
            return VirtualKey.EURO_SIGN;
        }
        if ("Begin".equals(keyStrokeName)) {
            return VirtualKey.BEGIN;
        }
        if ("numbersign".equals(keyStrokeName)) {
            return VirtualKey.NUMBER_SIGN;
        }
        if ("asciicircum".equals(keyStrokeName)) {
            return VirtualKey.CIRCUMFLEX;
        }
        if ("Kanji".equals(keyStrokeName)) {
            return VirtualKey.KANJI;
        }
        if ("Katakana".equals(keyStrokeName)) {
            return VirtualKey.KATAKANA;
        }
        if ("Hiragana_Katakana".equals(keyStrokeName)) {
            return VirtualKey.HIRAGANA;
        }
        if ("Muhenkan".equals(keyStrokeName)) {
            return VirtualKey.NONCONVERT;
        }
        if ("kan".equals(keyStrokeName)) {
            return VirtualKey.NONCONVERT;
        }
        if ("Henkan_Mode".equals(keyStrokeName)) {
            return VirtualKey.CONVERT;
        }
        if ("voicedsound".equals(keyStrokeName)) {
            return VirtualKey.DEAD_VOICED_SOUND;
        }
        if ("semivoicedsound".equals(keyStrokeName)) {
            return VirtualKey.DEAD_SEMIVOICED_SOUND;
        }
        if ("Menu".equals(keyStrokeName)) {
            return VirtualKey.CONTEXT_MENU;
        }
        Console.traceln((Level)Level.FINEST, (String)("unknown virtual key for key stroke " + keyStrokeName + " specified through " + "keyboard map for locale " + this.locale));
        return null;
    }

    private char determineCharacter(String keyStrokeName, boolean getUpper) {
        if ("Shift_R".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Shift_L".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Alt_R".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Mode_switch".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("ISO_Level3_Shift".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Alt_L".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Control_R".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Control_L".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Menu".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("1".equals(keyStrokeName)) {
            return '1';
        }
        if ("2".equals(keyStrokeName)) {
            return '2';
        }
        if ("3".equals(keyStrokeName)) {
            return '3';
        }
        if ("4".equals(keyStrokeName)) {
            return '4';
        }
        if ("5".equals(keyStrokeName)) {
            return '5';
        }
        if ("6".equals(keyStrokeName)) {
            return '6';
        }
        if ("7".equals(keyStrokeName)) {
            return '7';
        }
        if ("8".equals(keyStrokeName)) {
            return '8';
        }
        if ("9".equals(keyStrokeName)) {
            return '9';
        }
        if ("0".equals(keyStrokeName)) {
            return '0';
        }
        if ("BackSpace".equals(keyStrokeName)) {
            return '\b';
        }
        if ("Tab".equals(keyStrokeName)) {
            return '\t';
        }
        if ("ISO_Left_Tab".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("q".equals(keyStrokeName)) {
            return getUpper ? (char)'Q' : 'q';
        }
        if ("w".equals(keyStrokeName)) {
            return getUpper ? (char)'W' : 'w';
        }
        if ("e".equals(keyStrokeName)) {
            return getUpper ? (char)'E' : 'e';
        }
        if ("r".equals(keyStrokeName)) {
            return getUpper ? (char)'R' : 'r';
        }
        if ("t".equals(keyStrokeName)) {
            return getUpper ? (char)'T' : 't';
        }
        if ("y".equals(keyStrokeName)) {
            return getUpper ? (char)'Y' : 'y';
        }
        if ("u".equals(keyStrokeName)) {
            return getUpper ? (char)'U' : 'u';
        }
        if ("i".equals(keyStrokeName)) {
            return getUpper ? (char)'I' : 'i';
        }
        if ("o".equals(keyStrokeName)) {
            return getUpper ? (char)'O' : 'o';
        }
        if ("p".equals(keyStrokeName)) {
            return getUpper ? (char)'P' : 'p';
        }
        if ("a".equals(keyStrokeName)) {
            return getUpper ? (char)'A' : 'a';
        }
        if ("s".equals(keyStrokeName)) {
            return getUpper ? (char)'S' : 's';
        }
        if ("d".equals(keyStrokeName)) {
            return getUpper ? (char)'D' : 'd';
        }
        if ("f".equals(keyStrokeName)) {
            return getUpper ? (char)'F' : 'f';
        }
        if ("g".equals(keyStrokeName)) {
            return getUpper ? (char)'G' : 'g';
        }
        if ("h".equals(keyStrokeName)) {
            return getUpper ? (char)'H' : 'h';
        }
        if ("j".equals(keyStrokeName)) {
            return getUpper ? (char)'J' : 'j';
        }
        if ("k".equals(keyStrokeName)) {
            return getUpper ? (char)'K' : 'k';
        }
        if ("l".equals(keyStrokeName)) {
            return getUpper ? (char)'L' : 'l';
        }
        if ("Return".equals(keyStrokeName)) {
            return '\n';
        }
        if ("z".equals(keyStrokeName)) {
            return getUpper ? (char)'Z' : 'z';
        }
        if ("x".equals(keyStrokeName)) {
            return getUpper ? (char)'X' : 'x';
        }
        if ("c".equals(keyStrokeName)) {
            return getUpper ? (char)'C' : 'c';
        }
        if ("v".equals(keyStrokeName)) {
            return getUpper ? (char)'V' : 'v';
        }
        if ("b".equals(keyStrokeName)) {
            return getUpper ? (char)'B' : 'b';
        }
        if ("n".equals(keyStrokeName)) {
            return getUpper ? (char)'N' : 'n';
        }
        if ("m".equals(keyStrokeName)) {
            return getUpper ? (char)'M' : 'm';
        }
        if ("space".equals(keyStrokeName)) {
            return ' ';
        }
        if ("less".equals(keyStrokeName)) {
            return '<';
        }
        if ("greater".equals(keyStrokeName)) {
            return '>';
        }
        if ("bar".equals(keyStrokeName)) {
            return '|';
        }
        if ("brokenbar".equals(keyStrokeName)) {
            return '\u00a6';
        }
        if ("Escape".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F1".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F2".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F3".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F4".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F5".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F6".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F7".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F8".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F9".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F10".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F11".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("SunF36".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F12".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("SunF37".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Print".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Sys_Req".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Execute".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F22".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Scroll_Lock".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F23".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Insert".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Delete".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Home".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("End".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Page_Up".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Page_Down".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Left".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Up".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Down".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Right".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Num_Lock".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("KP_Divide".equals(keyStrokeName)) {
            return '/';
        }
        if ("KP_Multiply".equals(keyStrokeName)) {
            return '*';
        }
        if ("KP_Subtract".equals(keyStrokeName)) {
            return '-';
        }
        if ("KP_Add".equals(keyStrokeName)) {
            return '+';
        }
        if ("KP_Enter".equals(keyStrokeName)) {
            return '\n';
        }
        if ("KP_Decimal".equals(keyStrokeName)) {
            return ',';
        }
        if ("KP_Separator".equals(keyStrokeName)) {
            return ',';
        }
        if ("KP_Delete".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("KP_0".equals(keyStrokeName)) {
            return '0';
        }
        if ("KP_Insert".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("KP_1".equals(keyStrokeName)) {
            return '1';
        }
        if ("KP_End".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("KP_2".equals(keyStrokeName)) {
            return '2';
        }
        if ("KP_Down".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("KP_3".equals(keyStrokeName)) {
            return '3';
        }
        if ("KP_Next".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("KP_4".equals(keyStrokeName)) {
            return '4';
        }
        if ("KP_Left".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("KP_5".equals(keyStrokeName)) {
            return '5';
        }
        if ("KP_Begin".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("KP_6".equals(keyStrokeName)) {
            return '6';
        }
        if ("KP_Right".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("KP_7".equals(keyStrokeName)) {
            return '7';
        }
        if ("KP_Home".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("KP_8".equals(keyStrokeName)) {
            return '8';
        }
        if ("KP_Up".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("KP_9".equals(keyStrokeName)) {
            return '9';
        }
        if ("KP_Prior".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Caps_Lock".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Multi_key".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("exclam".equals(keyStrokeName)) {
            return '!';
        }
        if ("onesuperior".equals(keyStrokeName)) {
            return '\u00b9';
        }
        if ("exclamdown".equals(keyStrokeName)) {
            return '\u00a1';
        }
        if ("quotedbl".equals(keyStrokeName)) {
            return '\"';
        }
        if ("twosuperior".equals(keyStrokeName)) {
            return '\u00b2';
        }
        if ("oneeighth".equals(keyStrokeName)) {
            return '\u215b';
        }
        if ("section".equals(keyStrokeName)) {
            return '\u00a7';
        }
        if ("threesuperior".equals(keyStrokeName)) {
            return '\u00b3';
        }
        if ("sterling".equals(keyStrokeName)) {
            return '\u00a3';
        }
        if ("dollar".equals(keyStrokeName)) {
            return '$';
        }
        if ("onequarter".equals(keyStrokeName)) {
            return '\u00bc';
        }
        if ("currency".equals(keyStrokeName)) {
            return '\u00a4';
        }
        if ("percent".equals(keyStrokeName)) {
            return '%';
        }
        if ("onehalf".equals(keyStrokeName)) {
            return '\u00bd';
        }
        if ("threeeighths".equals(keyStrokeName)) {
            return '\u215c';
        }
        if ("ampersand".equals(keyStrokeName)) {
            return '&';
        }
        if ("threequarters".equals(keyStrokeName)) {
            return '\u00be';
        }
        if ("fiveeighths".equals(keyStrokeName)) {
            return '\u215d';
        }
        if ("slash".equals(keyStrokeName)) {
            return '/';
        }
        if ("braceleft".equals(keyStrokeName)) {
            return '{';
        }
        if ("seveneighths".equals(keyStrokeName)) {
            return '\u215e';
        }
        if ("parenleft".equals(keyStrokeName)) {
            return '(';
        }
        if ("bracketleft".equals(keyStrokeName)) {
            return '[';
        }
        if ("trademark".equals(keyStrokeName)) {
            return '\u2122';
        }
        if ("parenright".equals(keyStrokeName)) {
            return ')';
        }
        if ("bracketright".equals(keyStrokeName)) {
            return ']';
        }
        if ("plusminus".equals(keyStrokeName)) {
            return '\u00b1';
        }
        if ("equal".equals(keyStrokeName)) {
            return '=';
        }
        if ("braceright".equals(keyStrokeName)) {
            return '}';
        }
        if ("ssharp".equals(keyStrokeName)) {
            return '\u00df';
        }
        if ("question".equals(keyStrokeName)) {
            return '?';
        }
        if ("backslash".equals(keyStrokeName)) {
            return '\\';
        }
        if ("questiondown".equals(keyStrokeName)) {
            return '\u00bf';
        }
        if ("acute".equals(keyStrokeName)) {
            return '\u00b4';
        }
        if ("dead_acute".equals(keyStrokeName)) {
            return '\u0301';
        }
        if ("grave".equals(keyStrokeName)) {
            return '`';
        }
        if ("dead_grave".equals(keyStrokeName)) {
            return '\u0300';
        }
        if ("dead_cedilla".equals(keyStrokeName)) {
            return '\u0327';
        }
        if ("dead_ogonek".equals(keyStrokeName)) {
            return '\u0328';
        }
        if ("at".equals(keyStrokeName)) {
            return '@';
        }
        if ("Greek_OMEGA".equals(keyStrokeName)) {
            return '\u03a9';
        }
        if ("EuroSign".equals(keyStrokeName)) {
            return '\u20ac';
        }
        if ("paragraph".equals(keyStrokeName)) {
            return '\u2029';
        }
        if ("registered".equals(keyStrokeName)) {
            return '\u00ae';
        }
        if ("tslash".equals(keyStrokeName)) {
            return '\u0167';
        }
        if ("Tslash".equals(keyStrokeName)) {
            return '\u0166';
        }
        if ("z".equals(keyStrokeName)) {
            return getUpper ? (char)'Z' : 'z';
        }
        if ("leftarrow".equals(keyStrokeName)) {
            return '\u2190';
        }
        if ("yen".equals(keyStrokeName)) {
            return '\u00a5';
        }
        if ("downarrow".equals(keyStrokeName)) {
            return '\u2193';
        }
        if ("uparrow".equals(keyStrokeName)) {
            return '\u2191';
        }
        if ("rightarrow".equals(keyStrokeName)) {
            return '\u2192';
        }
        if ("idotless".equals(keyStrokeName)) {
            return '\u0131';
        }
        if ("oslash".equals(keyStrokeName)) {
            return '\u00f8';
        }
        if ("Ooblique".equals(keyStrokeName)) {
            return '\u00d8';
        }
        if ("thorn".equals(keyStrokeName)) {
            return '\u00fe';
        }
        if ("THORN".equals(keyStrokeName)) {
            return '\u00de';
        }
        if ("udiaeresis".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00dc' : '\u00fc';
        }
        if ("Udiaeresis".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00dc' : '\u00fc';
        }
        if ("dead_diaeresis".equals(keyStrokeName)) {
            return '\u0308';
        }
        if ("dead_abovering".equals(keyStrokeName)) {
            return '\u030a';
        }
        if ("plus".equals(keyStrokeName)) {
            return '+';
        }
        if ("asterisk".equals(keyStrokeName)) {
            return '*';
        }
        if ("asciitilde".equals(keyStrokeName)) {
            return '~';
        }
        if ("dead_tilde".equals(keyStrokeName)) {
            return '\u0303';
        }
        if ("dead_macron".equals(keyStrokeName)) {
            return '\u0304';
        }
        if ("ae".equals(keyStrokeName)) {
            return '\u00e6';
        }
        if ("AE".equals(keyStrokeName)) {
            return '\u00c6';
        }
        if ("eth".equals(keyStrokeName)) {
            return '\u00f0';
        }
        if ("ETH".equals(keyStrokeName)) {
            return '\u00d0';
        }
        if ("dstroke".equals(keyStrokeName)) {
            return getUpper ? (char)'\u0110' : '\u0111';
        }
        if ("ordfeminine".equals(keyStrokeName)) {
            return '\u00aa';
        }
        if ("eng".equals(keyStrokeName)) {
            return '\u014b';
        }
        if ("ENG".equals(keyStrokeName)) {
            return '\u014a';
        }
        if ("hstroke".equals(keyStrokeName)) {
            return '\u0127';
        }
        if ("Hstroke".equals(keyStrokeName)) {
            return '\u0126';
        }
        if ("kra".equals(keyStrokeName)) {
            return '\u0138';
        }
        if ("odiaeresis".equals(keyStrokeName)) {
            return '\u00f6';
        }
        if ("Odiaeresis".equals(keyStrokeName)) {
            return '\u00d6';
        }
        if ("dead_doubleacute".equals(keyStrokeName)) {
            return '\u030b';
        }
        if ("adiaeresis".equals(keyStrokeName)) {
            return '\u00e4';
        }
        if ("Adiaeresis".equals(keyStrokeName)) {
            return '\u00c4';
        }
        if ("dead_caron".equals(keyStrokeName)) {
            return '\u030c';
        }
        if ("asciicircum".equals(keyStrokeName)) {
            return '^';
        }
        if ("dead_circumflex".equals(keyStrokeName)) {
            return '\u0302';
        }
        if ("degree".equals(keyStrokeName)) {
            return '\u00b0';
        }
        if ("notsign".equals(keyStrokeName)) {
            return '\u00ac';
        }
        if ("numbersign".equals(keyStrokeName)) {
            return '#';
        }
        if ("apostrophe".equals(keyStrokeName)) {
            return '\'';
        }
        if ("dead_breve".equals(keyStrokeName)) {
            return '\u0306';
        }
        if ("y".equals(keyStrokeName)) {
            return getUpper ? (char)'Y' : 'y';
        }
        if ("guillemotleft".equals(keyStrokeName)) {
            return '\u00bb';
        }
        if ("guillemotright".equals(keyStrokeName)) {
            return '\u00ab';
        }
        if ("cent".equals(keyStrokeName)) {
            return '\u00a2';
        }
        if ("copyright".equals(keyStrokeName)) {
            return '\u00a9';
        }
        if ("leftdoublequotemark".equals(keyStrokeName)) {
            return '\u201e';
        }
        if ("rightdoublequotemark".equals(keyStrokeName)) {
            return '\u201c';
        }
        if ("mu".equals(keyStrokeName)) {
            return '\u00b5';
        }
        if ("masculine".equals(keyStrokeName)) {
            return '\u00ba';
        }
        if ("comma".equals(keyStrokeName)) {
            return ',';
        }
        if ("semicolon".equals(keyStrokeName)) {
            return ';';
        }
        if ("horizconnector".equals(keyStrokeName)) {
            return '\u00b7';
        }
        if ("multiply".equals(keyStrokeName)) {
            return '\u00d7';
        }
        if ("period".equals(keyStrokeName)) {
            return '.';
        }
        if ("colon".equals(keyStrokeName)) {
            return ':';
        }
        if ("periodcentered".equals(keyStrokeName)) {
            return '\u2026';
        }
        if ("division".equals(keyStrokeName)) {
            return '\u00f7';
        }
        if ("minus".equals(keyStrokeName)) {
            return '-';
        }
        if ("underscore".equals(keyStrokeName)) {
            return '_';
        }
        if ("dead_belowdot".equals(keyStrokeName)) {
            return '\u0323';
        }
        if ("dead_abovedot".equals(keyStrokeName)) {
            return '\u0307';
        }
        if ("eacute".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00c9' : '\u00e9';
        }
        if ("Eacute".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00c9' : '\u00e9';
        }
        if ("egrave".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00c8' : '\u00e8';
        }
        if ("Egrave".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00c8' : '\u00e8';
        }
        if ("ccedilla".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00c7' : '\u00e7';
        }
        if ("Ccedilla".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00c7' : '\u00e7';
        }
        if ("agrave".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00c0' : '\u00e0';
        }
        if ("Agrave".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00c0' : '\u00e0';
        }
        if ("lstroke".equals(keyStrokeName)) {
            return getUpper ? (char)'\u0141' : '\u0142';
        }
        if ("Lstroke".equals(keyStrokeName)) {
            return getUpper ? (char)'\u0141' : '\u0142';
        }
        if ("ugrave".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00d9' : '\u00f9';
        }
        if ("Ugrave".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00d9' : '\u00f9';
        }
        if ("igrave".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00cc' : '\u00ec';
        }
        if ("Igrave".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00cc' : '\u00ec';
        }
        if ("ograve".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00d2' : '\u00f2';
        }
        if ("ograve".equals(keyStrokeName)) {
            return getUpper ? (char)'\u00d2' : '\u00f2';
        }
        if ("keyboard_type".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("keyboard_subtype".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("keyboard_functionkeys".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("kana_NU".equals(keyStrokeName)) {
            return '\u30cc';
        }
        if ("kana_FU".equals(keyStrokeName)) {
            return '\u30d5';
        }
        if ("kana_A".equals(keyStrokeName)) {
            return '\u30a2';
        }
        if ("kana_a".equals(keyStrokeName)) {
            return '\u30a1';
        }
        if ("kana_U".equals(keyStrokeName)) {
            return '\u30a6';
        }
        if ("kana_u".equals(keyStrokeName)) {
            return '\u30a5';
        }
        if ("kana_E".equals(keyStrokeName)) {
            return '\u30a8';
        }
        if ("kana_e".equals(keyStrokeName)) {
            return '\u30a7';
        }
        if ("kana_O".equals(keyStrokeName)) {
            return '\u30aa';
        }
        if ("kana_o".equals(keyStrokeName)) {
            return '\u30a9';
        }
        if ("kana_YA".equals(keyStrokeName)) {
            return '\u30e4';
        }
        if ("kana_ya".equals(keyStrokeName)) {
            return '\u30e3';
        }
        if ("kana_YU".equals(keyStrokeName)) {
            return '\u30e6';
        }
        if ("kana_yu".equals(keyStrokeName)) {
            return '\u30e5';
        }
        if ("kana_YO".equals(keyStrokeName)) {
            return '\u30e8';
        }
        if ("kana_yo".equals(keyStrokeName)) {
            return '\u30e7';
        }
        if ("kana_WA".equals(keyStrokeName)) {
            return '\u30ef';
        }
        if ("kana_WO".equals(keyStrokeName)) {
            return '\u30f2';
        }
        if ("kana_HO".equals(keyStrokeName)) {
            return '\u30db';
        }
        if ("kana_HE".equals(keyStrokeName)) {
            return '\u30d8';
        }
        if ("kana_TA".equals(keyStrokeName)) {
            return '\u30bf';
        }
        if ("kana_TE".equals(keyStrokeName)) {
            return '\u30c6';
        }
        if ("kana_I".equals(keyStrokeName)) {
            return '\u30a4';
        }
        if ("kana_i".equals(keyStrokeName)) {
            return '\u30a3';
        }
        if ("kana_SU".equals(keyStrokeName)) {
            return '\u30b9';
        }
        if ("kana_KA".equals(keyStrokeName)) {
            return '\u30ab';
        }
        if ("kana_N".equals(keyStrokeName)) {
            return '\u30f3';
        }
        if ("kana_NA".equals(keyStrokeName)) {
            return '\u30ca';
        }
        if ("kana_NI".equals(keyStrokeName)) {
            return '\u30cb';
        }
        if ("kana_RA".equals(keyStrokeName)) {
            return '\u30e9';
        }
        if ("kana_SE".equals(keyStrokeName)) {
            return '\u30bb';
        }
        if ("voicedsound".equals(keyStrokeName)) {
            return '\u3099';
        }
        if ("semivoicedsound".equals(keyStrokeName)) {
            return '\u309a';
        }
        if ("kana_openingbracket".equals(keyStrokeName)) {
            return '\u04a2';
        }
        if ("kana_closingbracket".equals(keyStrokeName)) {
            return '\u04a3';
        }
        if ("kana_CHI".equals(keyStrokeName)) {
            return '\u30c1';
        }
        if ("kana_TO".equals(keyStrokeName)) {
            return '\u30c8';
        }
        if ("kana_SHI".equals(keyStrokeName)) {
            return '\u30b7';
        }
        if ("kana_HA".equals(keyStrokeName)) {
            return '\u30cf';
        }
        if ("kana_KI".equals(keyStrokeName)) {
            return '\u30ad';
        }
        if ("kana_KU".equals(keyStrokeName)) {
            return '\u30af';
        }
        if ("kana_MA".equals(keyStrokeName)) {
            return '\u30de';
        }
        if ("kana_NO".equals(keyStrokeName)) {
            return '\u30ce';
        }
        if ("kana_RI".equals(keyStrokeName)) {
            return '\u30ea';
        }
        if ("kana_RE".equals(keyStrokeName)) {
            return '\u30ec';
        }
        if ("kana_KE".equals(keyStrokeName)) {
            return '\u30b1';
        }
        if ("Zenkaku_Hankaku".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Kanji".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("kana_MU".equals(keyStrokeName)) {
            return '\u30e0';
        }
        if ("kana_TSU".equals(keyStrokeName)) {
            return '\u30c4';
        }
        if ("kana_tsu".equals(keyStrokeName)) {
            return '\u30c3';
        }
        if ("kana_SA".equals(keyStrokeName)) {
            return '\u30b5';
        }
        if ("kana_SO".equals(keyStrokeName)) {
            return '\u30bd';
        }
        if ("kana_HI".equals(keyStrokeName)) {
            return '\u30d2';
        }
        if ("kana_KO".equals(keyStrokeName)) {
            return '\u30b3';
        }
        if ("kana_MI".equals(keyStrokeName)) {
            return '\u30df';
        }
        if ("kana_MO".equals(keyStrokeName)) {
            return '\u30e2';
        }
        if ("kana_NE".equals(keyStrokeName)) {
            return '\u30cd';
        }
        if ("kana_comma".equals(keyStrokeName)) {
            return '\uff64';
        }
        if ("kana_RU".equals(keyStrokeName)) {
            return '\u30eb';
        }
        if ("kana_fullstop".equals(keyStrokeName)) {
            return '\uff61';
        }
        if ("kana_ME".equals(keyStrokeName)) {
            return '\u30e1';
        }
        if ("kana_conjunctive".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Henkan_Mode".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Hiragana_Katakana".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Katakana".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Romaji".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Muhenkan".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Eisu_toggle".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Eisu_toggle".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("F13".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Hangul".equals(keyStrokeName)) {
            return '\u0000';
        }
        if ("Hangul_Hanja".equals(keyStrokeName)) {
            return '\u0000';
        }
        Console.traceln((Level)Level.SEVERE, (String)("unknown key stroke name " + keyStrokeName + " specified through keyboard map " + "for locale " + this.locale));
        throw new IllegalArgumentException("no keyboard map available for locale " + this.locale);
    }
}

