package de.ugoe.cs.autoquest.plugin.usability2.rules.operator.filter;

import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.eventcore.gui.KeyInteraction;
import de.ugoe.cs.autoquest.eventcore.gui.KeyPressed;
import de.ugoe.cs.autoquest.keyboardmaps.VirtualKey;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.IResult;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.UnmatchableResult;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

public class KeyPressFilter extends EventTypeFilter {
    VirtualKey key;
    
    public KeyPressFilter(VirtualKey key) {
        super(KeyPressed.class);
        this.key = key;
    }

    @Override
    public IResult match(ITask task) {
        IResult match = super.match(task);
        if(match.isPresent()) {
            IEventType type = getType(task);
            if (type instanceof KeyInteraction) {
                VirtualKey key = ((KeyInteraction) type).getKey();
                if(key.equals(this.key))
                    return match;
            }
        }
        return UnmatchableResult.NO_MATCH_FOUND;
    }

}
