/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.util.console;

import de.ugoe.cs.util.StringTools;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.CommandParser;
import de.ugoe.cs.util.console.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.zip.ZipInputStream;

public class CommandExecuter {
    private static final CommandExecuter theInstance = new CommandExecuter();
    private static final String cmdPrefix = "CMD";
    private static final String defaultPackage = "de.ugoe.cs.util.console.defaultcommands";
    private List<String> commandPackageList = new ArrayList<String>();
    private Command[] availableCommands;

    public static synchronized CommandExecuter getInstance() {
        return theInstance;
    }

    private CommandExecuter() {
    }

    public void addCommandPackage(String pkg) {
        if ("".equals(pkg) || pkg == null) {
            throw new IllegalArgumentException("package name must not be null or empty string");
        }
        this.commandPackageList.add(pkg);
    }

    public void exec(String command) {
        Console.commandNotification(command);
        Command cmd = null;
        CommandParser parser = new CommandParser();
        parser.parse(command);
        int i = 0;
        while (cmd == null && i < this.commandPackageList.size()) {
            cmd = this.loadCMD(String.valueOf(this.commandPackageList.get(i)) + "." + cmdPrefix + parser.getCommandName());
            ++i;
        }
        if (cmd == null) {
            cmd = this.loadCMD("de.ugoe.cs.util.console.defaultcommands.CMD" + parser.getCommandName());
        }
        if (cmd == null) {
            Console.println("Unknown command");
        } else {
            try {
                cmd.run(parser.getParameters());
            }
            catch (IllegalArgumentException e) {
                Console.println("invalid parameter provided: " + e.getMessage());
                Console.println("Usage: " + cmd.help());
            }
            catch (Exception e) {
                Console.println("error executing command: " + e);
                Console.logException(e);
                Console.println("Usage: " + cmd.help());
            }
        }
    }

    public Command loadCMD(String className) {
        Command cmd = null;
        try {
            Class<?> cmdClass = Class.forName(className);
            cmd = (Command)cmdClass.newInstance();
        }
        catch (NoClassDefFoundError e) {
            String[] splitResult = e.getMessage().split(cmdPrefix);
            String correctName = splitResult[splitResult.length - 1].replace(")", "");
            Console.println("Did you mean " + correctName + "?");
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
        }
        catch (ClassCastException e) {
            Console.traceln(Level.WARNING, String.valueOf(className) + "found, but does not implement Command");
        }
        return cmd;
    }

    public Command getCMD(String commandName) {
        Command cmd = null;
        int i = 0;
        while (cmd == null && i < this.commandPackageList.size()) {
            cmd = this.loadCMD(String.valueOf(this.commandPackageList.get(i)) + "." + cmdPrefix + commandName);
            ++i;
        }
        if (cmd == null) {
            cmd = this.loadCMD("de.ugoe.cs.util.console.defaultcommands.CMD" + commandName);
        }
        return cmd;
    }

    public Command[] getAvailableCommands() {
        if (this.availableCommands == null) {
            ArrayList<Command> commands = new ArrayList<Command>();
            ArrayList<String> packages = new ArrayList<String>();
            packages.addAll(this.commandPackageList);
            packages.add(defaultPackage);
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name != null && name.startsWith(CommandExecuter.cmdPrefix) && name.endsWith(".class");
                }
            };
            TreeSet<String> classNames = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String arg1, String arg2) {
                    String str1 = arg1.substring(arg1.lastIndexOf(46) + CommandExecuter.cmdPrefix.length() + 1);
                    String str2 = arg2.substring(arg2.lastIndexOf(46) + CommandExecuter.cmdPrefix.length() + 1);
                    return str1.compareTo(str2);
                }
            });
            for (String packageName : packages) {
                String path = packageName.replace('.', '/');
                try {
                    Enumeration<URL> resources = ClassLoader.getSystemResources(path);
                    while (resources.hasMoreElements()) {
                        String className;
                        URL resource = resources.nextElement();
                        File packageDir = new File(resource.getFile());
                        if (packageDir.isDirectory()) {
                            File[] fileArray = packageDir.listFiles(filter);
                            int n = fileArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File classFile = fileArray[n2];
                                className = classFile.getName().substring(0, classFile.getName().lastIndexOf(46));
                                classNames.add(String.valueOf(packageName) + "." + className);
                                ++n2;
                            }
                            continue;
                        }
                        int index = resource.getFile().lastIndexOf(33);
                        if (index <= 0 || !resource.getFile().startsWith("file:") || !resource.getFile().endsWith("!/" + path)) continue;
                        String jarFile = resource.getFile().substring("file:".length(), index);
                        ZipInputStream jarInputStream = null;
                        try {
                            try {
                                jarInputStream = new JarInputStream(new FileInputStream(jarFile));
                                JarEntry entry = null;
                                do {
                                    if ((entry = ((JarInputStream)jarInputStream).getNextJarEntry()) == null || entry.isDirectory() || !entry.getName().startsWith(path)) continue;
                                    className = entry.getName().substring(path.length() + 1, entry.getName().lastIndexOf(46));
                                    classNames.add(String.valueOf(packageName) + "." + className);
                                } while (entry != null);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                Console.traceln(Level.WARNING, "could not read contents of jar " + jarFile);
                                if (jarInputStream == null) continue;
                                jarInputStream.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            if (jarInputStream != null) {
                                jarInputStream.close();
                            }
                            throw throwable;
                        }
                        if (jarInputStream == null) continue;
                        jarInputStream.close();
                    }
                }
                catch (IOException e) {
                    Console.traceln(Level.WARNING, "could not read commands of package " + packageName);
                }
            }
            for (String className : classNames) {
                Command cmd = this.loadCMD(className);
                if (cmd == null) continue;
                commands.add(cmd);
            }
            this.availableCommands = commands.toArray(new Command[commands.size()]);
        }
        return Arrays.copyOf(this.availableCommands, this.availableCommands.length);
    }

    public List<String> getCommandPackages() {
        ArrayList<String> commandPackageListCopy = new ArrayList<String>(this.commandPackageList);
        commandPackageListCopy.add(0, defaultPackage);
        return commandPackageListCopy;
    }

    public String autoCompleteCommand(String commandPrefix) {
        Command[] commands = this.getAvailableCommands();
        String[] completions = new String[commands.length];
        int i = 0;
        while (i < commands.length) {
            completions[i] = commands[i].getClass().getSimpleName().substring(3);
            ++i;
        }
        return StringTools.autocomplete(commandPrefix, completions);
    }
}

