/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousCloseException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.ProxyConfiguration;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public abstract class HttpDestination
implements Destination,
Closeable,
Dumpable {
    protected static final Logger LOG = Log.getLogger(HttpDestination.class);
    private final HttpClient client;
    private final String scheme;
    private final String host;
    private final Destination.Address address;
    private final Queue<HttpExchange> exchanges;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private final Destination.Address proxyAddress;
    private final HttpField hostField;

    public HttpDestination(HttpClient client, String scheme, String host, int port) {
        this.client = client;
        this.scheme = scheme;
        this.host = host;
        this.address = new Destination.Address(host, port);
        this.exchanges = new BlockingArrayQueue(client.getMaxRequestsQueuedPerDestination());
        this.requestNotifier = new RequestNotifier(client);
        this.responseNotifier = new ResponseNotifier(client);
        ProxyConfiguration proxyConfig = client.getProxyConfiguration();
        Destination.Address address = this.proxyAddress = proxyConfig != null && proxyConfig.matches(host, port) ? new Destination.Address(proxyConfig.getHost(), proxyConfig.getPort()) : null;
        if (!client.isDefaultPort(scheme, port)) {
            host = host + ":" + port;
        }
        this.hostField = new HttpField(HttpHeader.HOST, host);
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public Queue<HttpExchange> getHttpExchanges() {
        return this.exchanges;
    }

    public RequestNotifier getRequestNotifier() {
        return this.requestNotifier;
    }

    public ResponseNotifier getResponseNotifier() {
        return this.responseNotifier;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.address.getPort();
    }

    public Destination.Address getConnectAddress() {
        return this.isProxied() ? this.proxyAddress : this.address;
    }

    public boolean isProxied() {
        return this.proxyAddress != null;
    }

    public URI getProxyURI() {
        ProxyConfiguration proxyConfiguration = this.client.getProxyConfiguration();
        String uri = this.getScheme() + "://" + proxyConfiguration.getHost();
        if (!this.client.isDefaultPort(this.getScheme(), proxyConfiguration.getPort())) {
            uri = uri + ":" + proxyConfiguration.getPort();
        }
        return URI.create(uri);
    }

    public HttpField getHostField() {
        return this.hostField;
    }

    protected void send(Request request, List<Response.ResponseListener> listeners) {
        if (!this.scheme.equals(request.getScheme())) {
            throw new IllegalArgumentException("Invalid request scheme " + request.getScheme() + " for destination " + this);
        }
        if (!this.getHost().equals(request.getHost())) {
            throw new IllegalArgumentException("Invalid request host " + request.getHost() + " for destination " + this);
        }
        int port = request.getPort();
        if (port >= 0 && this.getPort() != port) {
            throw new IllegalArgumentException("Invalid request port " + port + " for destination " + this);
        }
        HttpConversation conversation = this.client.getConversation(request.getConversationID(), true);
        HttpExchange exchange = new HttpExchange(conversation, this, request, listeners);
        if (this.client.isRunning()) {
            if (this.exchanges.offer(exchange)) {
                if (!this.client.isRunning() && this.exchanges.remove(exchange)) {
                    throw new RejectedExecutionException((Object)((Object)this.client) + " is stopping");
                }
                LOG.debug("Queued {}", new Object[]{request});
                this.requestNotifier.notifyQueued(request);
                this.send();
            } else {
                LOG.debug("Max queued exceeded {}", new Object[]{request});
                this.abort(exchange, new RejectedExecutionException("Max requests per destination " + this.client.getMaxRequestsQueuedPerDestination() + " exceeded for " + this));
            }
        } else {
            throw new RejectedExecutionException((Object)((Object)this.client) + " is stopped");
        }
    }

    protected abstract void send();

    @Override
    public void newConnection(Promise<Connection> promise) {
        this.createConnection(new ProxyPromise(promise));
    }

    protected void createConnection(Promise<Connection> promise) {
        this.client.newConnection(this, promise);
    }

    public boolean remove(HttpExchange exchange) {
        return this.exchanges.remove(exchange);
    }

    @Override
    public void close() {
        this.abort(new AsynchronousCloseException());
        LOG.debug("Closed {}", new Object[]{this});
    }

    public void abort(Throwable cause) {
        HttpExchange exchange;
        while ((exchange = this.exchanges.poll()) != null) {
            this.abort(exchange, cause);
        }
    }

    protected void abort(HttpExchange exchange, Throwable cause) {
        Request request = exchange.getRequest();
        HttpResponse response = exchange.getResponse();
        this.getRequestNotifier().notifyFailure(request, cause);
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        this.getResponseNotifier().notifyFailure(listeners, (Response)response, cause);
        this.getResponseNotifier().notifyComplete(listeners, new Result(request, cause, response, cause));
    }

    protected void tunnelSucceeded(Connection connection, Promise<Connection> promise) {
        promise.succeeded((Object)this.client.getTransport().tunnel(connection));
    }

    protected void tunnelFailed(Connection connection, Promise<Connection> promise, Throwable failure) {
        promise.failed(failure);
        connection.close();
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject((Appendable)out, (Object)(this + " - requests queued: " + this.exchanges.size()));
    }

    public String asString() {
        return this.client.address(this.getScheme(), this.getHost(), this.getPort());
    }

    public String toString() {
        return String.format("%s(%s)%s", HttpDestination.class.getSimpleName(), this.asString(), this.proxyAddress == null ? "" : " via " + this.proxyAddress.getHost() + ":" + this.proxyAddress.getPort());
    }

    private class ProxyPromise
    implements Promise<Connection> {
        private final Promise<Connection> delegate;

        private ProxyPromise(Promise<Connection> delegate) {
            this.delegate = delegate;
        }

        public void succeeded(Connection connection) {
            if (HttpDestination.this.isProxied() && HttpScheme.HTTPS.is(HttpDestination.this.getScheme())) {
                if (HttpDestination.this.client.getSslContextFactory() != null) {
                    this.tunnel(connection);
                } else {
                    String message = String.format("Cannot perform requests over SSL, no %s in %s", SslContextFactory.class.getSimpleName(), HttpClient.class.getSimpleName());
                    this.delegate.failed((Throwable)new IllegalStateException(message));
                }
            } else {
                this.delegate.succeeded((Object)connection);
            }
        }

        public void failed(Throwable x) {
            this.delegate.failed(x);
        }

        private void tunnel(final Connection connection) {
            String target = HttpDestination.this.address.getHost() + ":" + HttpDestination.this.address.getPort();
            Request connect = HttpDestination.this.client.newRequest(HttpDestination.this.proxyAddress.getHost(), HttpDestination.this.proxyAddress.getPort()).scheme(HttpScheme.HTTP.asString()).method(HttpMethod.CONNECT).path(target).header(HttpHeader.HOST, target).timeout(HttpDestination.this.client.getConnectTimeout(), TimeUnit.MILLISECONDS);
            connection.send(connect, new Response.CompleteListener(){

                @Override
                public void onComplete(Result result) {
                    if (result.isFailed()) {
                        HttpDestination.this.tunnelFailed(connection, (Promise<Connection>)ProxyPromise.this.delegate, result.getFailure());
                    } else {
                        Response response = result.getResponse();
                        if (response.getStatus() == 200) {
                            HttpDestination.this.tunnelSucceeded(connection, (Promise<Connection>)ProxyPromise.this.delegate);
                        } else {
                            HttpDestination.this.tunnelFailed(connection, (Promise<Connection>)ProxyPromise.this.delegate, new HttpResponseException("Received " + response + " for " + result.getRequest(), response));
                        }
                    }
                }
            });
        }
    }
}

