//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInfo;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.tasktrees.treeifc.TaskMetric;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public enum UsabilityDefectSeverity {
    
    INFO, LOW, MEDIUM, HIGH;
    
    /** */
    static int defaultCoverageQuantile = 950;

    /**
     * 
     */
    static UsabilityDefectSeverity getSeverity(int ratio,
                                               int highRatioLevel,
                                               int mediumRatioLevel,
                                               int lowRatioLevel,
                                               int infoRatioLevel)
    {
        return getSeverity(ratio, highRatioLevel, mediumRatioLevel, lowRatioLevel, infoRatioLevel,
                           defaultCoverageQuantile);
    }

    /**
     * 
     */
    static UsabilityDefectSeverity getSeverity(int        ratio,
                                               int        highRatioLevel,
                                               int        mediumRatioLevel,
                                               int        lowRatioLevel,
                                               int        infoRatioLevel,
                                               ITask      taskWithDefect,
                                               ITaskModel wholeTaskModel)
    {
        ITaskInfo taskInfo = wholeTaskModel.getTaskInfo(taskWithDefect);
        int eventCoverageQuantile = taskInfo.getMeasureValue(TaskMetric.EVENT_COVERAGE_QUANTILE);
        return getSeverity(ratio, highRatioLevel, mediumRatioLevel, lowRatioLevel, infoRatioLevel,
                           eventCoverageQuantile);
    }

    /**
     * 
     */
    static UsabilityDefectSeverity getSeverity(int ratio,
                                               int highRatioLevel,
                                               int mediumRatioLevel,
                                               int lowRatioLevel,
                                               int infoRatioLevel,
                                               int coverageQuantile)
    {
        int effectiveRatio = ratio;
        
        // event coverage ratio is in per mille. The more executed events a task covers, the more
        // important a related usability defect.
        /*if (eventCoverageRatio < 1) {
            // one per mille, so one of thousand events is covered
            effectiveRatio *= 0.2;
        }
        else if (eventCoverageRatio < 5) {
            // 5 per mille, so one of 250 events is covered
            effectiveRatio *= 0.4;
        }
        else if (eventCoverageRatio < 10) {
            // 1 percent, so one of 100 events is covered
            effectiveRatio *= 0.5;
        }
        else if (eventCoverageRatio < 20) {
            // 2 percent, so one of 50 events is covered
            effectiveRatio *= 0.6;
        }
        else if (eventCoverageRatio < 30) {
            // 3 percent, so one of 33 events is covered
            effectiveRatio *= 0.7;
        }
        else if (eventCoverageRatio < 40) {
            // 4 percent, so one of 28 events is covered
            effectiveRatio *= 0.8;
        }
        else if (eventCoverageRatio < 50) {
            // 5 percent, so one of 25 events is covered
            effectiveRatio *= 0.9;
        }*/
        //else {
            // more than 5 percent, so 1 of 20 events, do not change ratio
        //}
        if (coverageQuantile >= defaultCoverageQuantile) {
            if (effectiveRatio >= highRatioLevel) {
                return UsabilityDefectSeverity.HIGH;
            }
            else if (effectiveRatio >= mediumRatioLevel) {
                return UsabilityDefectSeverity.MEDIUM;
            }
            else if (effectiveRatio >= lowRatioLevel) {
                return UsabilityDefectSeverity.LOW;
            }
            else if (effectiveRatio >= infoRatioLevel) {
                return UsabilityDefectSeverity.INFO;
            }
        }
        
        return null;
    }
}
