/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.httpmonitor.proxy;

import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorComponent;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorException;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorExchangeHandler;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorLogManager;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorServer;
import de.ugoe.cs.autoquest.httpmonitor.ShutdownHook;
import de.ugoe.cs.autoquest.httpmonitor.proxy.ExchangeListenerManager;
import de.ugoe.cs.autoquest.httpmonitor.proxy.HttpMonitorRemoteExchangeHandler;
import de.ugoe.cs.autoquest.httpmonitor.proxy.HttpMonitoringProxyServlet;
import de.ugoe.cs.util.console.Console;
import javax.servlet.Servlet;

public class HttpMonitoringProxy
implements HttpMonitorComponent {
    private int port;
    private HttpMonitorServer server;
    private ExchangeListenerManager exchangeListenerManager;
    private HttpMonitorExchangeHandler exchangeHandler;
    private String logFileBaseDir;
    private Thread shutdownHook;
    private String proxiedServer;
    private int proxiedPort;
    private String httpMonitorServer;
    private int httpMonitorPort;

    public HttpMonitoringProxy(String[] commandLineArguments) {
        if (commandLineArguments.length != 4) {
            Console.printerrln((String)"invalid number of command line parameters. Three are required:");
            Console.printerrln((String)"  1. the port on which to listen");
            Console.printerrln((String)"  2. the server and port to be proxied (format \"host:port\")");
            Console.printerrln((String)"  3. variant a: the value \"local\" for logging recorded exchanges locally");
            Console.printerrln((String)"     variant b: the server and port of the HTTP monitor to send the recorded\n                exchanges to (format \"host:port\")");
            throw new IllegalArgumentException();
        }
        this.logFileBaseDir = commandLineArguments[0];
        try {
            this.port = Integer.parseInt(commandLineArguments[1]);
        }
        catch (NumberFormatException e) {
            Console.printerrln((String)("invalid port specification " + commandLineArguments[1]));
        }
        Console.println((String)("listening on port " + this.port));
        this.proxiedServer = commandLineArguments[2];
        int index = this.proxiedServer.indexOf(58);
        if (index > -1) {
            try {
                this.proxiedPort = Integer.parseInt(this.proxiedServer.substring(index + 1));
            }
            catch (NumberFormatException e) {
                Console.printerrln((String)("invalid port specification " + this.proxiedServer.substring(index + 1)));
            }
            this.proxiedServer = this.proxiedServer.substring(0, index);
        } else {
            this.proxiedPort = 80;
        }
        Console.println((String)("proxing " + this.proxiedServer + ":" + this.proxiedPort));
        this.httpMonitorServer = commandLineArguments[3];
        index = this.httpMonitorServer.indexOf(58);
        if (index > -1) {
            try {
                this.httpMonitorPort = Integer.parseInt(this.httpMonitorServer.substring(index + 1));
            }
            catch (NumberFormatException e) {
                Console.printerrln((String)("invalid port specification " + this.httpMonitorServer.substring(index + 1)));
            }
            this.httpMonitorServer = this.httpMonitorServer.substring(0, index);
        } else if ("local".equals(this.httpMonitorServer)) {
            this.httpMonitorServer = null;
        } else {
            this.httpMonitorPort = 80;
        }
        if (this.httpMonitorServer != null) {
            Console.println((String)("sending log data to " + this.httpMonitorServer + ":" + this.httpMonitorPort));
            this.exchangeHandler = new HttpMonitorRemoteExchangeHandler(this.httpMonitorServer, this.httpMonitorPort);
        } else {
            Console.println((String)("storing logs locally into directory " + this.logFileBaseDir));
            this.exchangeHandler = new HttpMonitorLogManager(this.logFileBaseDir);
        }
    }

    @Override
    public synchronized void init() throws HttpMonitorException {
        if (this.server != null) {
            throw new IllegalStateException("already initialized.");
        }
        this.exchangeHandler.init();
        this.exchangeListenerManager = new ExchangeListenerManager(this.exchangeHandler);
        this.exchangeListenerManager.init();
        HttpMonitoringProxyServlet servlet = new HttpMonitoringProxyServlet(this.proxiedServer, this.proxiedPort, this.exchangeListenerManager);
        this.server = new HttpMonitorServer(this.port, (Servlet)servlet);
        this.server.init();
        this.shutdownHook = new Thread(new ShutdownHook(this.server, this.exchangeListenerManager, this.exchangeHandler));
    }

    @Override
    public synchronized void start() {
        if (this.exchangeHandler == null || this.exchangeListenerManager == null || this.server == null) {
            throw new IllegalStateException("not initialized.");
        }
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.exchangeHandler.start();
            this.exchangeListenerManager.start();
            this.server.start();
        }
        catch (HttpMonitorException e) {
            Console.printerrln((String)("could not start HTTP monitoring proxy: " + e));
            Console.logException((Exception)e);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.exchangeHandler == null || this.exchangeListenerManager == null || this.server == null) {
            throw new IllegalStateException("not initialized.");
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        this.server.stop();
        this.exchangeListenerManager.stop();
        this.exchangeHandler.stop();
        this.server = null;
        this.exchangeListenerManager = null;
        this.exchangeHandler = null;
    }
}

