//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usageprofiles;

import java.util.List;

/**
 * <p>
 * This interface defines basic functions for classes that implement a memory about the recent
 * events of a sequences.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 * 
 * @param <T>
 *            Type of the sequence elements that are memorized.
 */
public interface IMemory<T> {

    /**
     * Adds an element to the end of the memory.
     * 
     * @param element
     *            Element to be added.
     */
    public void add(T element);

    /**
     * <p>
     * Returns the last <code>num</code> memorized elements. If the history is shorter than
     * <code>num</code>, the length of the returned {@link java.util.List} may be less than
     * <code>num</code>.
     * </p>
     * 
     * @param num
     *            Number of states from the end of the memory to be returned.
     * @return {@link java.util.List} of memorized elements.
     */
    public List<T> getLast(int num);

}
