/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.eventbench.jfcmonitor;

import de.ugoe.cs.util.StringTools;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;

public class JFCComponent {
    private static Map<Component, JFCComponent> knownComponents = new HashMap<Component, JFCComponent>();
    private JFCComponent parent = null;
    private List<JFCComponent> children = new LinkedList<JFCComponent>();
    private Component component;
    private String title = null;
    private String componentClass = null;
    private String icon = null;
    private int index = -1;

    public static void add(Component component) {
        JFCComponent.add(component, JFCComponent.find(component.getParent()));
    }

    public static void add(Component component, JFCComponent parent) {
        if (!knownComponents.containsKey(component)) {
            knownComponents.put(component, new JFCComponent(component, parent));
        }
    }

    public static JFCComponent find(Component component) {
        return knownComponents.get(component);
    }

    public static void remove(Component component) {
        JFCComponent jfcComponent = knownComponents.remove(component);
        if (jfcComponent != null) {
            jfcComponent.removeFromParent();
            jfcComponent.removeChildren();
        }
    }

    private JFCComponent(Component component, JFCComponent parent) {
        if (component == null) {
            throw new InvalidParameterException("parameter component must not be null");
        }
        this.component = component;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        if (component instanceof Container) {
            for (Component childComponent : ((Container)component).getComponents()) {
                JFCComponent.add(childComponent, this);
            }
        }
    }

    private void addChild(JFCComponent child) {
        this.children.add(child);
    }

    public String getXML() {
        this.setClass();
        this.setIcon();
        this.setIndex();
        this.setTitle();
        StringBuilder builder = new StringBuilder();
        if (this.parent != null) {
            builder.append(this.parent.getXML());
        }
        builder.append("  <component>" + StringTools.ENDLINE);
        builder.append("   <param name=\"title\" value=\"" + this.title + "\" />" + StringTools.ENDLINE);
        builder.append("   <param name=\"class\" value=\"" + this.componentClass + "\" />" + StringTools.ENDLINE);
        builder.append("   <param name=\"icon\" value=\"" + this.icon + "\" />" + StringTools.ENDLINE);
        builder.append("   <param name=\"index\" value=\"" + this.index + "\" />" + StringTools.ENDLINE);
        builder.append("   <param name=\"hash\" value=\"" + Integer.toHexString(this.component.hashCode()) + "\" />" + StringTools.ENDLINE);
        builder.append("  </component>" + StringTools.ENDLINE);
        return builder.toString();
    }

    private void removeChild(JFCComponent child) {
        this.children.remove(child);
    }

    private void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    private void removeChildren() {
        for (JFCComponent child : this.children) {
            JFCComponent.remove(child.component);
        }
    }

    private void setTitle() {
        this.title = null;
        AccessibleContext accessibleContext = this.component.getAccessibleContext();
        if (accessibleContext != null) {
            this.title = accessibleContext.getAccessibleName();
        }
        if (this.title == null) {
            this.title = this.icon;
        }
        if (this.title == null) {
            this.title = this.component.getName();
        }
        if (this.title == null) {
            this.title = "Pos(" + this.component.getX() + "," + this.component.getY() + ")";
        }
    }

    private void setClass() {
        this.componentClass = this.component.getClass().getName();
    }

    private void setIcon() {
        this.icon = null;
        try {
            String iconPath;
            Object iconObject;
            Method getIconMethod = this.component.getClass().getMethod("getIcon", new Class[0]);
            if (getIconMethod != null && (iconObject = getIconMethod.invoke((Object)this.component, new Object[0])) != null && !(iconPath = iconObject.toString()).contains("@")) {
                System.out.println("iconPath");
                String[] splitResult = iconPath.split(File.separatorChar == '\\' ? "\\\\" : File.separator);
                this.icon = splitResult[splitResult.length - 1];
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            System.err.println("Found method with name getIcon but could not access it.");
        }
    }

    private void setIndex() {
        this.index = -1;
        AccessibleContext accessibleContext = this.component.getAccessibleContext();
        if (accessibleContext != null) {
            this.index = accessibleContext.getAccessibleIndexInParent();
        }
    }
}

