//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.taskequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.eventcore.StringEventType;
import de.ugoe.cs.autoquest.tasktrees.taskequality.SequenceComparisonRule;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.test.DummyGUIElement;

/**
 * @author Patrick Harms
 */
public class SequenceComparisonRuleTest extends AbstractComparisonRuleTest {

    /**
     *
     */
    @Test
    public void test_isApplicable_01() {
        SequenceComparisonRule rule = new SequenceComparisonRule();
        
        ITask task1 = createNewSequence();
        
        assertTrue(rule.isApplicable(task1, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_02() {
        SequenceComparisonRule rule = new SequenceComparisonRule();

        ITask task1 = createNewSequence();
        ITask task2 = createNewSequence();
        
        assertTrue(rule.isApplicable(task1, task2));
        assertTrue(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_03() {
        SequenceComparisonRule rule = new SequenceComparisonRule();

        ITask task1 = createNewSequence();
        ITask task2 = createNewSelection();
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_04() {
        SequenceComparisonRule rule = new SequenceComparisonRule();

        ITask task1 = createNewSequence();
        ITask task2 = createNewIteration();
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_05() {
        SequenceComparisonRule rule = new SequenceComparisonRule();

        ITask task1 = createNewSequence();
        ITask task2 = createNewOptional();
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_06() {
        SequenceComparisonRule rule = new SequenceComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        ITask task1 = createNewSequence();
        ITask task2 = createNewEventTask(eventType1, eventTarget1);
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     * 
     */
    @Test
    public void test_compare_01() {
        SequenceComparisonRule rule = new SequenceComparisonRule();
        
        ISequence sequence1 = createNewSequence();
        assertLexicallyEqual(rule, sequence1, sequence1);
    }

    /**
     * 
     */
    @Test
    public void test_compare_02() {
        SequenceComparisonRule rule = new SequenceComparisonRule();
        
        ISequence sequence1 = createNewSequence();
        ISequence sequence2 = createNewSequence();
        
        assertLexicallyEqual(rule, sequence1, sequence2);
    }

    /**
     * 
     */
    @Test
    public void test_compare_03() {
        SequenceComparisonRule rule = new SequenceComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        ISequence sequence1 = createNewSequence();
        ISequence sequence2 = createNewSequence();
        
        addChild(sequence1, task1);
        
        assertUnequal(rule, sequence1, sequence2);
    }

    /**
     * 
     */
    @Test
    public void test_compare_04() {
        SequenceComparisonRule rule = new SequenceComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        ISequence sequence1 = createNewSequence();
        ISequence sequence2 = createNewSequence();
        
        addChild(sequence1, task1);
        addChild(sequence2, task1);
        
        assertLexicallyEqual(rule, sequence1, sequence2);
    }

    /**
     * 
     */
    @Test
    public void test_compare_05() {
        SequenceComparisonRule rule = new SequenceComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        IEventType eventType2 = new StringEventType("eventType2");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");

        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        ITask task2 = createNewEventTask(eventType2, eventTarget2);
        
        ISequence sequence1 = createNewSequence();
        ISequence sequence2 = createNewSequence();
        
        addChild(sequence1, task1);
        addChild(sequence2, task1);
        
        addChild(sequence1, task2);
        
        assertUnequal(rule, sequence1, sequence2);
    }

    /**
     * 
     */
    @Test
    public void test_compare_06() {
        SequenceComparisonRule rule = new SequenceComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        IEventType eventType2 = new StringEventType("eventType2");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");

        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        ITask task2 = createNewEventTask(eventType2, eventTarget2);
        
        ISequence sequence1 = createNewSequence();
        ISequence sequence2 = createNewSequence();
        
        addChild(sequence1, task1);
        addChild(sequence2, task1);
        
        addChild(sequence1, task2);
        addChild(sequence2, task2);
        
        assertLexicallyEqual(rule, sequence1, sequence2);
    }

    /**
     * 
     */
    @Test
    public void test_compare_07() {
        SequenceComparisonRule rule = new SequenceComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        IEventType eventType2 = new StringEventType("eventType2");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");

        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        ITask task2 = createNewEventTask(eventType2, eventTarget2);
        
        ISequence sequence1 = createNewSequence();
        ISequence sequence2 = createNewSequence();
        
        addChild(sequence1, task1);
        addChild(sequence1, task2);
        
        addChild(sequence2, task2);
        addChild(sequence2, task1);
        
        assertUnequal(rule, sequence1, sequence2);
    }

}
