//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.taskequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.eventcore.StringEventType;
import de.ugoe.cs.autoquest.tasktrees.taskequality.TaskAndIterationComparisonRule;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.test.DummyGUIElement;

/**
 * @author Patrick Harms
 */
public class TaskAndIterationComparisonRuleTest extends AbstractComparisonRuleTest {

    /**
     *
     */
    @Test
    public void test_isApplicable_01() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();
        
        ITask task1 = createNewSequence();
        
        assertFalse(rule.isApplicable(task1, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_02() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();
        
        ITask task1 = createNewSelection();
        
        assertFalse(rule.isApplicable(task1, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_03() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();
        
        ITask task1 = createNewIteration();
        
        assertFalse(rule.isApplicable(task1, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_04() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();
        
        ITask task1 = createNewOptional();
        
        assertFalse(rule.isApplicable(task1, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_05() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        assertFalse(rule.isApplicable(task1, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_06() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();

        ITask task1 = createNewIteration();
        ITask task2 = createNewSequence();
        
        assertTrue(rule.isApplicable(task1, task2));
        assertTrue(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_07() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();

        ITask task1 = createNewIteration();
        ITask task2 = createNewSelection();
        
        assertTrue(rule.isApplicable(task1, task2));
        assertTrue(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_08() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();

        ITask task1 = createNewIteration();
        ITask task2 = createNewOptional();
        
        assertTrue(rule.isApplicable(task1, task2));
        assertTrue(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_09() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();

        ITask task1 = createNewIteration();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        ITask task2 = createNewEventTask(eventType1, eventTarget1);
        
        assertTrue(rule.isApplicable(task1, task2));
        assertTrue(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_10() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();

        ITask task1 = createNewSequence();
        ITask task2 = createNewSelection();
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_11() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();

        ITask task1 = createNewSequence();
        ITask task2 = createNewOptional();
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_12() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();

        ITask task1 = createNewSequence();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        ITask task2 = createNewEventTask(eventType1, eventTarget1);
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_13() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();

        ITask task1 = createNewSelection();
        ITask task2 = createNewOptional();
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_14() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();

        ITask task1 = createNewSelection();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        ITask task2 = createNewEventTask(eventType1, eventTarget1);
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_compare_01() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        IIteration iteration1 = createNewIteration();
        
        assertNullEquality(rule, iteration1, task1);
    }

    /**
     *
     */
    @Test
    public void test_compare_02() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        IIteration iteration1 = createNewIteration();
        setMarkedTask(iteration1, task1);
        
        assertLexicallyEqual(rule, task1, iteration1);
    }

    /**
     *
     */
    @Test
    public void test_compare_03() {
        TaskAndIterationComparisonRule rule = new TaskAndIterationComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        IIteration iteration1 = createNewIteration();
        
        ISelection selection1 = createNewSelection();
        addChild(selection1, task1);
        setMarkedTask(iteration1, selection1);
        
        assertLexicallyEqual(rule, task1, iteration1);
    }

}
