//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usageprofiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.junit.*;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.StringEventType;
import de.ugoe.cs.autoquest.usageprofiles.FirstOrderMarkovModel;
import de.ugoe.cs.autoquest.usageprofiles.FirstOrderMarkovModel.MarkovEdge;
import static org.junit.Assert.*;

/**
 * The class <code>FirstOrderMarkovModelTest</code> contains tests for the class
 * <code>{@link FirstOrderMarkovModel}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class FirstOrderMarkovModelTest {

	Collection<List<Event>> sequences;
	
	@Test
	public void testFirstOrderMarkovModel_1() throws Exception {
		Random r = new Random();

		FirstOrderMarkovModel result = new FirstOrderMarkovModel(r);

		assertNotNull(result);
		assertEquals(r, result.r);
		assertEquals(2, result.trieOrder);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testFirstOrderMarkovModel_2() throws Exception {
		new FirstOrderMarkovModel(null);
	}
	
	@Test
	public void testCalcEntropy() throws Exception {
		Random r = new Random();
		FirstOrderMarkovModel fixture = new FirstOrderMarkovModel(r);
		fixture.train(sequences);
		
		double result = fixture.calcEntropy();
		
		assertEquals(0.7392d, result, 0.0001);
	}
	
	@Test
	public void testMarkovEdgeMarkovEdge_1() throws Exception {
		double weight = 0.2d;
		
		MarkovEdge result = new MarkovEdge(weight);
		
		assertNotNull(result);
		assertEquals(weight, result.weight, 0.0001);
	}
	
	@Test
	public void testMarkovEdgeToString_1() throws Exception {
		double weight = 0.2d;
		MarkovEdge fixture = new MarkovEdge(weight);
		
		String result = fixture.toString();
		
		assertEquals(Double.toString(0.2d), result);
	}
	
	@Before
	public void setUp() throws Exception {
		List<Event> sequence = new ArrayList<Event>();
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("b")));
		sequence.add(new Event(new StringEventType("r")));
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("c")));
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("d")));
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("b")));
		sequence.add(new Event(new StringEventType("r")));
		sequence.add(new Event(new StringEventType("a")));

		sequences = new ArrayList<List<Event>>();
		sequences.add(sequence);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(FirstOrderMarkovModelTest.class);
	}
}