//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.jfcmonitor;

import java.io.IOException;
import java.io.OutputStreamWriter;

import de.ugoe.cs.util.StringTools;
/**
 * <p>
 * This class is used as wrapper for writers for JFCMonitor logs. 
 * </p>
 * @author Fabian Glaser
 * @version 1.0
 *
 */
public class JFCMonitorOutputWriter{
	 /**
     * <p>
     * Writer for logging events.
     * </p>
     */
    final private OutputStreamWriter outputWriter;
    
    /**
     * <p>
     * Constructor. Creates a new JFCMonitorOutputWriter with a given {@link OutputStreamWriter}, where the
     * monitored information is written to. It writes log header information on construction to 
     * given OutputStreamWriter.  
     * </p>
     * 
     * @param outputWriter
     *            writer for the logged information
     */
    
    public JFCMonitorOutputWriter(OutputStreamWriter outputWriter) {
        this.outputWriter = outputWriter;
        write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + StringTools.ENDLINE);
        write("<sessions>" + StringTools.ENDLINE);
    }
    
    /**
     * <p>
     * Writes a string to the internal OutputStreamWriter.
     * </p>
     * @param str
     */
    public synchronized void write(String str){
    	try {
			outputWriter.write(str);
			outputWriter.flush();
		} catch (IOException e) {
	        System.err.println("JFCMONITOR -- Failure writing to log: " + e.getMessage());
		}
    }
}
