package de.ugoe.cs.autoquest.plugin.alignment.substitution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;

import java.util.List;

import misc.AlignmentHelpers;
import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.util.console.GlobalDataContainer;

public class ObjectDistanceSubstitionMatrix implements SubstitutionMatrix {

	private ArrayList<int[][]> matrix;
	private int currentSequence;
	
	
	public ObjectDistanceSubstitionMatrix() {
		currentSequence = 0;
		matrix = new ArrayList<int[][]>();
	}
	
	@Override
	public String info() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public double getDistance(int pos1, int pos2) {
		// TODO Auto-generated method stub
		
		return matrix.get(currentSequence)[pos1][pos2];
	}
	
	public double getDistance(int sequence, int pos1, int pos2) {
		return  matrix.get(sequence)[pos1][pos2];
		
		
	}

	@Override
	public double getGapPenalty() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void generate(Collection<List<Event>> eventList) {
		
		for(Iterator<List<Event>> seqs = eventList.iterator(); seqs.hasNext();) {
			matrix.add(new int[eventList.size()][eventList.size()]);
			List<Event> tmpList = seqs.next();
			
			for (int i=0; i < tmpList.size(); i++) {
				for (int j=0; j < tmpList.size(); j++) {
					IGUIElement first = (IGUIElement) tmpList.get(i).getTarget();
					IGUIElement second =(IGUIElement) tmpList.get(j).getTarget();
					matrix.get(currentSequence)[i][j] = AlignmentHelpers.distanceBetween(first, second);
				}
			}			
		}
	}
}
