
package de.ugoe.cs.autoquest.usability;

import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTypeFilter.MOUSE_CLICK;
import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTypeFilter.TEXT_INPUT;
import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.TaskTypeFilter.ITERATION;
import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.TaskTypeFilter.SEQUENCE;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.rules.patterns.InteractionPattern;
import de.ugoe.cs.autoquest.usability.rules.patterns.InteractionPatternBuilder;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskModelUtil;

public class SimpleTest {
    public static void main(String[] args) {
        // Given
        String spec = "UserSession {" +
                      "  Sequence seq1 {" + 
                      "    TextInput t1 {}" +
                      "    Selection sel1 {" +
                      "      Sequence seq2 {" +
                      "        MouseClick mc1 {}" +
                      "        TextInput t2 {}" +
                      "      }" +
                      "    }" +
                      "    Iteration it1 {" +
                      "      MouseClick mc2 {}" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        
        InteractionPattern containedPattern =
            InteractionPatternBuilder.newPattern().rootTask(SEQUENCE).startsWithEvent(MOUSE_CLICK)
                .endsWithEvent(TEXT_INPUT).patternFinished().build();
        
        //InteractionPattern outerContainedPattern =
        //    InteractionPatternBuilder.newPattern().rootTask(ANY).containsPattern(containedPattern).patternFinished().build();
        
        InteractionPattern endsWithPattern =
            InteractionPatternBuilder.newPattern().rootTask(ITERATION).startsWithEvent(MOUSE_CLICK)
                .patternFinished().build();
        
        InteractionPattern pattern =
            InteractionPatternBuilder.newPattern().rootTask(SEQUENCE).startsWithEvent(TEXT_INPUT)
                .containsPattern(containedPattern).endsWithPattern(endsWithPattern)
                .patternFinished().build();
     
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        System.out.println(patternContained);
    }
}
