//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.usability2.rules.operator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import de.ugoe.cs.autoquest.plugin.usability2.rules.results.IResult;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Konni Hartmann
 */
public abstract class AbstractFilterOperator implements IFilter {
    
    private final List<IFilter> filters;


    public AbstractFilterOperator(List<IFilter> filters) {
        this.filters = Collections.unmodifiableList(new ArrayList<IFilter>(filters));
    }
    
    public AbstractFilterOperator(IFilter... filters) {
        this(Arrays.asList(filters));
    }

    public abstract IResult match(ITask task, List<IFilter> filters);

    @Override
    public IResult match(ITask task) {
        return match(task, filters);
    }
    
}
