//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.usability2.rules.operator.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import de.ugoe.cs.autoquest.eventcore.IEventType;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Konni Hartmann
 */
public class MultiEventTypeFilter extends EventTypeFilter {

    Collection<Class<? extends IEventType>> eventTypes;
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param eventTypeClazz
     */
    public MultiEventTypeFilter(Collection<Class<? extends IEventType>> eventTypes) {
        super(null);
        this.eventTypes = new ArrayList<Class<? extends IEventType>>(eventTypes);
    }

    public MultiEventTypeFilter(Class<? extends IEventType>... eventTypes) {
        super(null);
        this.eventTypes = Arrays.asList(eventTypes);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.plugin.usability2.rules.operator.filter.EventTypeFilter#matchesType(de.ugoe.cs.autoquest.eventcore.IEventType, java.lang.Class)
     */
    @Override
    protected boolean matchesType(IEventType type, Class<? extends IEventType> eventTypeClazz) {
        for (Class<? extends IEventType> targetType : eventTypes  ) {
            if (super.matchesType(type, targetType))
                return true;
        }
        return false;
    }

    public boolean matchesType(IEventType type) {
        return this.matchesType(type, null);
    }
    
}
