package de.ugoe.cs.autoquest.plugin.usability2.rules.operator.transformer;

import de.ugoe.cs.autoquest.plugin.usability2.rules.operator.IFilter;
import de.ugoe.cs.autoquest.plugin.usability2.rules.operator.IResultTransformer;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.DefaultMatch;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.IMatch;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.IResult;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.TransformedResult;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

public class CurrentTaskAsResultTransformer implements IResultTransformer {

    public static final IResultTransformer CURRENT_TASK_AS_RESULT_TRANSFORMER = new CurrentTaskAsResultTransformer();
    
    private CurrentTaskAsResultTransformer(){
        super();
    }
    
    @Override
    public IResult transform(IResult result, IFilter filter, final ITask task) {
        return new TransformedResult(result) {
            
            @Override
            protected IMatch transform(IMatch next) {
                return new DefaultMatch(task, next.getLabeledResults());
            }
        }; 
    }

}
